% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardReexports.R
\name{addCwres}
\alias{addCwres}
\title{Add CWRES}
\usage{
addCwres(fit, focei = TRUE, updateObject = TRUE, envir = parent.frame(1))
}
\arguments{
\item{fit}{nlmixr2 fit without WRES/CWRES}

\item{focei}{Boolean indicating if the focei objective function is
added.  If not the foce objective function is added.}

\item{updateObject}{Boolean indicating if the original fit object
should be updated. By default this is true.}

\item{envir}{Environment that should be checked for object to
update.  By default this is the global environment.}
}
\value{
fit with CWRES
}
\description{
This returns a new fit object with CWRES attached
}
\examples{
\donttest{

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

f <- try(nlmixr2(one.cmt, theo_sd, "saem"))

print(f)

# even though you may have forgotten to add the cwres, you can add it to the data.frame:

if (!inherits(f, "try-error")) {
  f <- try(addCwres(f))
  print(f)
}

# Note this also adds the FOCEi objective function
}
}
\author{
Matthew L. Fidler
}
