% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions_processInputList.R
\name{distributionInfo}
\alias{distributionInfo}
\alias{getDistributionInfo}
\alias{getParamNames}
\alias{getType}
\alias{isUserDefined}
\alias{pqDefined}
\title{Get information about a distribution}
\usage{
getDistributionInfo(dist)

isUserDefined(dist)

pqDefined(dist)

getType(dist, params = NULL, valueOnly = is.null(params) && !includeParams,
  includeParams = !is.null(params))

getParamNames(dist, includeValue = TRUE)
}
\arguments{
\item{dist}{a character vector of length one, giving the name of the distribution (as used in BUGS code), e.g. \code{'dnorm'}}

\item{params}{an optional character vector of names of parameters for which dimensions are desired (possibly including \'value\' and alternate parameters)}

\item{valueOnly}{a logical indicating whether to only return the dimension of the value of the node}

\item{includeParams}{a logical indicating whether to return dimensions of parameters. If TRUE and \'params\' is NULL then dimensions of all parameters, including the dimension of the value of the node, are returned}

\item{includeValue}{a logical indicating whether to return the string 'value', which is the name of the node value}
}
\description{
Give information about each BUGS distribution
}
\details{
NIMBLE provides various functions to give information about a BUGS distribution. In some cases, functions of the same name and similar functionality operate on the node(s) of a model as well (see \code{help(modelBaseClass)}).

\code{getDistributionInfo} returns an internal data structure (a reference class object) providing various information about the distribution. The output is not very user-friendly, but does contain all of the information that NIMBLE has about the distribution.

\code{isDiscrete} tests if a BUGS distribution is a discrete distribution.

\code{isUserDefined} tests if a BUGS distribution is a user-defined distribution.

\code{pqAvail} tests if a BUGS distribution provides distribution ('p') and quantile ('q') functions.

\code{getDimension} provides the dimension of the value and/or parameters of a BUGS distribution. The return value is a numeric vector with an element for each parameter/value requested.

\code{getType} provides the type (numeric, logical, integer) of the value and/or parameters of a BUGS distribution. The return value is a character vector with an element for each parameter/value requested. At present, all quantities are stored as numeric (double) values, so this function is of little practical use but could be exploited in the future.

\code{getParamNames} provides the value and/or parameter names of a BUGS distribution.
}
\examples{
distInfo <- getDistributionInfo('dnorm')
distInfo
distInfo$range

isDiscrete('dbin')

isUserDefined('dbin')

pqDefined('dgamma')
pqDefined('dmnorm')

getDimension('dnorm')
getDimension('dnorm', includeParams = TRUE)
getDimension('dnorm', c('var', 'sd'))
getDimension('dcat', includeParams = TRUE)
getDimension('dwish', includeParams = TRUE)

getType('dnorm')
getType('dnorm', includeParams = TRUE)
getType('dnorm', c('var', 'sd'))
getType('dcat', includeParams = TRUE)
getType('dwish', includeParams = TRUE)

getParamNames('dnorm', includeValue = FALSE)
getParamNames('dmnorm')
}
\author{
Christopher Paciorek
}

