% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp9wH6ZH/file2ef7725fe91c
\name{nfMethod}
\alias{nfMethod}
\title{access (call) a member function of a nimbleFunction}
\usage{
nfMethod(nf, methodName)
}
\arguments{
\item{nf}{a specialized nimbleFunction, i.e. one that has already had setup parameters processed}

\item{methodName}{a character string giving the name of the member function to call}
}
\value{
a function that can be called.
}
\description{
Internal function for accessing a member function (method) of a nimbleFunction.  Normally a user will write \code{nf$method(x)} instead of \code{nfMethod(nf, method)(x)}.
}
\details{
nimbleFunctions have a default member function called \code{run}, and may have other member functions provided via the \code{methods} argument to \code{nimbleFunction}.
As an internal step, the NIMBLE compiler turns \code{nf$method(x)} into \code{nfMethod(nf, method)(x)}, but a NIMBLE user or programmer would not normally need to use \code{nfMethod} directly.
}
\author{
NIMBLE development team
}

