% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBR.R
\name{NBR}
\alias{NBR}
\title{NBR - Normalized Burn Ratio}
\usage{
NBR(NIR, SWIR2)
}
\arguments{
\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}

\item{SWIR2}{A raster layer object with the reflectance values for the Short Wave Infrared band.}
}
\value{
NBR - Normalized Burn Ratio.
}
\description{
NBR is used to identify burned areas and provide a measure of burn severity.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
NBR(x[[5]], x[[7]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
