% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_nhdplus.R
\name{get_flowline_index}
\alias{get_flowline_index}
\title{Get Flowline Index}
\usage{
get_flowline_index(
  flines,
  points,
  search_radius = 0.1,
  precision = NA,
  max_matches = 1
)
}
\arguments{
\item{flines}{sf data.frame of type LINESTRING or MULTILINESTRING including
COMID, REACHCODE, ToMeas, and FromMeas. Can be "download_nhdplusv2" and remote
nhdplusv2 data will be downloaded for the bounding box surround the submitted points.
NOTE: The download option may not work for large areas, use with caution.}

\item{points}{sf or sfc of type POINT}

\item{search_radius}{numeric the distance for the nearest neighbor search
to extend.
See RANN nn2 documentation for more details.}

\item{precision}{numeric the resolution of measure precision in the output in meters.}

\item{max_matches}{numeric the maximum number of matches to return if multiple are
found in search_radius}
}
\value{
data.frame with five columns, id, COMID, REACHCODE, REACH_meas, and offset. id is the
row or list element in the point input.
}
\description{
given an sf point geometry column, return COMID, reachcode,
and measure for each.
}
\details{
Note 1: Inputs are cast into LINESTRINGS. Because of this,
the measure output
of inputs that are true multipart lines may be in error.

Note 2: This algorithm finds the nearest node in the input flowlines to
identify which flowline the point should belong to. As a second pass,
it can calculate the measure to greater precision than the nearest flowline
geometry node.

Note 3: Offset is returned in units consistent with the projection of
the flowlines.

Note 4: See `dfMaxLength` input to sf::st_segmentize() for details of
handling of precision parameter.
}
\examples{
\donttest{

source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

get_flowline_index(sample_flines,
                   sf::st_sfc(sf::st_point(c(-76.87479,
                                             39.48233)),
                              crs = 4326))

get_flowline_index("download_nhdplusv2",
                   sf::st_sfc(sf::st_point(c(-76.87479,
                                             39.48233)),
                              crs = 4326))

get_flowline_index(sample_flines,
                   sf::st_sfc(sf::st_point(c(-76.87479,
                                             39.48233)),
                              crs = 4326), precision = 30)

get_flowline_index(sample_flines,
                   sf::st_sfc(list(sf::st_point(c(-76.86934, 39.49328)),
                                   sf::st_point(c(-76.91711, 39.40884)),
                                   sf::st_point(c(-76.88081, 39.36354))),
                              crs = 4326),
                   search_radius = 0.2,
                   max_matches = 10)

}
}
