% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinpaint_utils.R
\name{format_pp_meta_age}
\alias{format_pp_meta_age}
\title{To format ProteinPaint input meta data of age}
\usage{
format_pp_meta_age(raw_meta, outfn = NULL, age_group = "Age",
  adult_value = "Adult", child_value = "Pediatric",
  adult_color = "#c20b01", child_color = "#196abd", ...)
}
\arguments{
\item{raw_meta}{A data.frame contain cols of 'sample', 'term', 
'group', 'value', 'color' and 'legendorder'}

\item{outfn}{Output file, default is NULL and not output to file}

\item{age_group}{Name of age group, default is 'Age'}

\item{adult_value}{Value of adult, default is 'Adult'}

\item{child_value}{Value of child, default is 'Pediatric'}

\item{adult_color}{Color of adult, default is '#c20b01'}

\item{child_color}{Color of child, default is '#196abd'}

\item{...}{Parameters pass to \code{\link{set_colors}}}
}
\value{
A data frame
}
\description{
To format ProteinPaint input meta data of age
}
\examples{

meta_template <- system.file('extdata', 
'demo/proteinpaint/heatmap_meta_template.txt', 
package = 'ngstk')
raw_meta <- read.table(meta_template, sep = '\\t', header = TRUE)
term <- group <- 'Age'
raw_meta$term <- term
raw_meta$group <- group
raw_meta$value <- c(rep(c('Adult', 'Pediatric'), 3),  'Male')
meta_age <- format_pp_meta_age(raw_meta)
}
