% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinpaint_utils.R
\name{format_pp_meta_gender}
\alias{format_pp_meta_gender}
\title{To format ProteinPaint input meta data of gender}
\usage{
format_pp_meta_gender(raw_meta, outfn = NULL, gender_group = "Gender",
  male_value = "Male", female_value = "Female", male_color = "#c20b01",
  female_color = "#196abd", ...)
}
\arguments{
\item{raw_meta}{A data.frame contain cols of 'sample', 
'term', 'group', 'value', 'color' and 'legendorder'}

\item{outfn}{Output file, default is NULL and not output to file}

\item{gender_group}{Name of age group, default is 'Gender'}

\item{male_value}{Value of male, default is 'Male'}

\item{female_value}{Value of female, default is 'Female'}

\item{male_color}{Color of male, default is '#c20b01'}

\item{female_color}{Color of female, default is '#196abd'}

\item{...}{Parameters pass to \code{\link{set_colors}}}
}
\value{
A data frame
}
\description{
To format ProteinPaint input meta data of gender
}
\examples{
meta_template <- system.file('extdata', 
'demo/proteinpaint/heatmap_meta_template.txt', package = 'ngstk')
raw_meta <- read.table(meta_template, sep = '\\t', header = TRUE)
term <- group <- 'Gender'
raw_meta$term <- term
raw_meta$group <- group
raw_meta$value <- c(rep(c('Male', 'Female'), 3), 'Male')
meta_gender <- format_pp_meta_gender(raw_meta)
}
