% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_division_ranks.R
\name{compute_division_ranks}
\alias{compute_division_ranks}
\title{Compute NFL Division Rankings using Game Results}
\usage{
compute_division_ranks(
  games,
  teams = NULL,
  tiebreaker_depth = 3,
  .debug = FALSE,
  h2h = NULL
)
}
\arguments{
\item{games}{A data frame containing real or simulated game scores. The
following variables are required:
\describe{
\item{sim}{A simulation ID. Normally 1 - n simulated seasons.}
\item{game_type}{One of 'REG', 'WC', 'DIV', 'CON', 'SB' indicating if a game was a regular season game or one of the playoff rounds.}
\item{week}{The week of the corresponding NFL season.}
\item{away_team}{Team abbreviation of the away team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{home_team}{Team abbreviation of the home team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{result}{Equals home score - away score.}
}}

\item{teams}{This parameter is optional. If it is \code{NULL} the function
will compute it internally, otherwise it has to be a data frame of all teams
contained in the \code{games} data frame repeated for each simulation ID
(\code{sim}). The following variables are required:
\describe{
\item{sim}{A simulation ID. Normally 1 - n simulated seasons.}
\item{team}{Team abbreviation of the team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{conf}{Conference abbreviation of the team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{division}{Division of the team (please see
\code{\link{divisions}} for valid division names).}
}}

\item{tiebreaker_depth}{A single value equal to 1, 2, or 3. The default is 3. The
value controls the depth of tiebreakers that shall be applied. The deepest
currently implemented tiebreaker is strength of schedule. The following
values are valid:
\describe{
\item{tiebreaker_depth = 1}{Break all ties with a coinflip. Fastest variant.}
\item{tiebreaker_depth = 2}{Apply head-to-head and division win percentage tiebreakers. Random if still tied.}
\item{tiebreaker_depth = 3}{Apply all tiebreakers through strength of schedule. Random if still tied.}
}}

\item{.debug}{Either \code{TRUE} or \code{FALSE}. Controls whether additional
messages are printed to the console showing what the tie-breaking algorithms
are currently performing.}

\item{h2h}{A data frame that is used for head-to-head tiebreakers across the
tie-breaking functions. It is computed by the function
\code{\link{compute_division_ranks}}.}
}
\value{
A list of two data frames:
\describe{
\item{standings}{Division standings.}
\item{h2h}{A data frame that is used for head-to-head tiebreakers across the
tie-breaking functions.}
}
}
\description{
Compute NFL Division Rankings using Game Results
}
\examples{
\donttest{
# Change some options for better output
old <- options(list(digits = 3, tibble.print_min = 64))
library(dplyr, warn.conflicts = FALSE)

nflseedR::load_sharpe_games() \%>\%
  dplyr::filter(season \%in\% 2019:2020) \%>\%
  dplyr::select(sim = season, game_type, week, away_team, home_team, result) \%>\%
  nflseedR::compute_division_ranks() \%>\%
  purrr::pluck("standings")

# Restore old options
options(old)
}
}
\seealso{
The examples \href{https://nflseedr.com/articles/articles/nflseedR.html}{on the package website}
}
