% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_name_cleaning.R
\name{clean_homeaway}
\alias{clean_homeaway}
\title{Clean Home/Away in dataframes into Team/Opponent dataframes}
\usage{
clean_homeaway(dataframe, invert = NULL)
}
\arguments{
\item{dataframe}{dataframe}

\item{invert}{a character vector of columns that gets inverted when referring to the away team (e.g. home spread = 1 gets converted to away_spread = -1)}
}
\value{
a dataframe with one row per team (twice as long as the input dataframe)
}
\description{
This function converts dataframes with "home_" and "away_" prefixed columns to "team_" and "opponent_", and doubles the rows. This makes sure that there's one row for each team (as opposed to one row for each game).
}
\examples{
\donttest{
# a small example dataframe
s <- data.frame(
   game_id = c("2020_20_TB_GB", "2020_20_BUF_KC", "2020_21_KC_TB"), 
   game_type = c("CON", "CON", "SB"), 
   away_team = c("TB", "BUF", "KC"), 
   away_score = c(31L, 24L, 9L), 
   home_team = c("GB", "KC", "TB"), 
   home_score = c(26L, 38L, 31L), 
   location = c("Home", "Home", "Neutral"), 
   result = c(-5L, 14L, 22L), 
   spread_line = c(3, 3, -3)
 )

clean_homeaway(s, invert = c("result","spread_line"))
}
}
