% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sitrep.R
\name{nflverse_sitrep}
\alias{nflverse_sitrep}
\alias{ffverse_sitrep}
\alias{.sitrep}
\title{Get a Situation Report on System, nflverse/ffverse Package Versions and Dependencies}
\usage{
nflverse_sitrep(
  pkg = c("nflreadr", "nflfastR", "nflseedR", "nfl4th", "nflplotR", "nflverse"),
  recursive = TRUE,
  redact_path = TRUE
)

ffverse_sitrep(
  pkg = c("ffscrapr", "ffsimulator", "ffpros", "ffopportunity"),
  recursive = TRUE,
  redact_path = TRUE
)

.sitrep(pkg, recursive = TRUE, header = "", redact_path = TRUE)
}
\arguments{
\item{pkg}{a character vector naming installed packages, or \code{NULL}
(the default) meaning all nflverse packages. The function checks internally
if all packages are installed and informs if that is not the case.}

\item{recursive}{a logical indicating whether dependencies of \code{pkg} and their
dependencies (and so on) should be included.
Can also be a character vector listing the types of dependencies, a subset
of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string \code{"all"} is shorthand for that vector, character string
\code{"most"} for the same vector without \code{"Enhances"}, character string \code{"strong"}
(default) for the first three elements of that vector.}

\item{redact_path}{a logical indicating whether options that contain "path"
in the name should be redacted, default = TRUE}

\item{header}{a string that is printed in the horizontal separation lines and
used to differentiate between nflverse and ffverse output.}
}
\description{
This function gives a quick overview of the versions of R and the operating
system as well as the versions of nflverse/ffverse packages, options, and their dependencies.
It's primarily designed to help you get a quick idea of what's going on when
you're helping someone else debug a problem.
}
\examples{
\donttest{
try({
nflverse_sitrep()
ffverse_sitrep()
.sitrep("cachem")
})
}
}
