% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/margin.R
\docType{methods}
\name{margin}
\alias{margin}
\alias{margin-method}
\alias{margin,CompositionMatrix-method}
\title{Marginal Compositions}
\usage{
margin(x, ...)

\S4method{margin}{CompositionMatrix}(x, parts = c(1, 2), name = "*")
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{parts}{An \code{\link{integer}} or a \code{\link{character}} vector specifying the columns
to be selected.}

\item{name}{A \code{\link{character}} string giving the name of the amalgamation
column.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Marginal Compositions
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Marginal compositions
mar <- margin(coda, parts = c("B", "D"))
head(mar)
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
