% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/group.R
\docType{methods}
\name{group}
\alias{group}
\alias{group-method}
\alias{ungroup}
\alias{group,CompositionMatrix-method}
\alias{group,GroupedComposition-method}
\alias{ungroup,GroupedComposition-method}
\alias{ungroup,GroupedLR-method}
\alias{ungroup,GroupedCLR-method}
\alias{ungroup,GroupedALR-method}
\alias{ungroup,GroupedILR-method}
\alias{ungroup,GroupedPLR-method}
\title{Working With Groups}
\usage{
group(object, ...)

ungroup(object, ...)

\S4method{group}{CompositionMatrix}(object, by, verbose = getOption("nexus.verbose"), ...)

\S4method{group}{GroupedComposition}(object, by, add = FALSE, verbose = getOption("nexus.verbose"), ...)

\S4method{ungroup}{GroupedComposition}(object)

\S4method{ungroup}{GroupedLR}(object)

\S4method{ungroup}{GroupedCLR}(object)

\S4method{ungroup}{GroupedALR}(object)

\S4method{ungroup}{GroupedILR}(object)

\S4method{ungroup}{GroupedPLR}(object)
}
\arguments{
\item{object}{An \R object (typically, a \code{\linkS4class{CompositionMatrix}} object).}

\item{...}{Further parameters to be passed to internal methods.}

\item{by}{A possible value for the groups of \code{object} (typically, a
\code{\link{character}} vector). If \code{value} is a \code{\link{list}},
\code{\link[=interaction]{interaction(by)}} defines the grouping.}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}

\item{add}{A \code{\link{logical}} scalar. If \code{TRUE}, add to existing groups.}
}
\value{
\itemize{
\item \code{group()} returns a grouped object of the same sort as \code{object}.
\item \code{ungroup()} returns an ungrouped object of the same sort as \code{object}.
}
}
\description{
Define or remove the (reference) groups to which the observations belong.
}
\details{
Missing values (\code{NA}) can be used to specify that a sample does not belong
to any group.
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to compositional data
coda <- as_composition(slides, groups = 2)

## Grouping metadata
group_levels(coda)

group_names(coda)

group_indices(coda)

group_rows(coda)

group_length(coda)

group_size(coda)
}
\seealso{
Other grouping methods: 
\code{\link{group_extract}()},
\code{\link{group_metadata}},
\code{\link{group_split}()}
}
\author{
N. Frerebeau
}
\concept{grouping methods}
