#' Arctic Lake
#'
#' Sand, silt, clay compositions of 39 sediment samples at different water
#' depths in an Arctic lake.
#' @format A [`data.frame`] with 4 variables:
#'  \describe{
#'    \item{sand}{Sand content (percent).}
#'    \item{silt}{Silt content (percent).}
#'    \item{clay}{Clay content (percent).}
#'    \item{depth}{Water depth (m).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"arctic"

#' Hongite Mineralogy
#'
#' Mineral compositions of 25 rock specimens of hongite type.
#' @format A [`data.frame`] with 5 variables (minerals):
#'  \describe{
#'    \item{A}{Albite (percent).}
#'    \item{B}{Blandite (percent).}
#'    \item{C}{Cornite (percent).}
#'    \item{D}{Daubite (percent).}
#'    \item{E}{Endite (percent).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"hongite"

#' Thin Sections
#'
#' Mineral compositions of five slides as reported by five analysts.
#' @format A [`data.frame`] with 9 variables:
#'  \describe{
#'    \item{analyst}{Analyst number.}
#'    \item{slide}{Slide number.}
#'    \item{quartz}{Quartz (percent).}
#'    \item{microcline}{Microcline (percent).}
#'    \item{plagioclass}{Plagioclass (percent).}
#'    \item{biotite}{Biotite (percent).}
#'    \item{plagioclass}{Plagioclass (percent).}
#'    \item{muscovite}{Muscovite (percent).}
#'    \item{opaques}{Opaque minerals (percent).}
#'    \item{nonopaques}{Non-opaque minerals (percent).}
#'  }
#' @references
#'  Aitchison, J. (1986). *The Statistical Analysis of Compositional Data*.
#'  London: Chapman and Hall.
#' @family datasets
#' @keywords datasets
"slides"

#' Can Sora Petrographic Data
#'
#' @format A [`data.frame`] with 21 variables:
#'  \describe{
#'    \item{VAR1}{Optical activity.}
#'    \item{VAR2}{Inclusion orientation.}
#'    \item{VAR3}{Void orientation.}
#'    \item{VAR4}{Texture.}
#'    \item{VAR5}{Special components.}
#'    \item{VAR6}{Plutonic rocks.}
#'    \item{VAR7}{Volcanic rocks.}
#'    \item{VAR8}{Metamorphic rocks.}
#'    \item{VAR9}{Sedimentary rocks.}
#'    \item{VAR10}{Quartz.}
#'    \item{VAR11}{Feldspar.}
#'    \item{VAR12}{Plagioclase.}
#'    \item{VAR13}{Pyroxenes.}
#'    \item{VAR14}{Amphiboles.}
#'    \item{VAR15}{Micas.}
#'    \item{VAR16}{Phyllosilicates.}
#'    \item{VAR17}{Carbonates.}
#'    \item{VAR18}{Other constituents.}
#'    \item{VAR19}{Packing.}
#'  }
#' @references
#'  Cau, M.-A., Day, P. M., Baxter, M. J., Papageorgiou, I., Iliopoulos, I. &
#'  Montana, G. (2004). Exploring Automatic Grouping Procedures in Ceramic
#'  Petrology. *Journal of Archaeological Science*, 31(9): 1325-1338.
#'  \doi{10.1016/j.jas.2004.03.006}.
#' @family datasets
#' @keywords datasets
"petrography"

#' Can Sora Chemical Data
#'
#' @format A [`data.frame`] with 30 variables.
#' @references
#'  Cau, M.-A. (1999). Importaciones de cerámica tardorromana de cocina en las
#'  Iles Balears: el caso de Can Sora (Eivissa). In J. Capel Martinez,
#'  *Arqueometria y Arqueologia*, p. 197-219. Granada: Editorial Universidad de
#'  Granada. Monografica Arte y Arqueología 47.
#' @family datasets
#' @keywords datasets
"chemistry"
