% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{as_features}
\alias{as_features}
\alias{as_features-method}
\alias{as_features,CompositionMatrix-method}
\title{Coerce to Features}
\usage{
as_features(from, ...)

\S4method{as_features}{CompositionMatrix}(from)
}
\arguments{
\item{from}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{data.frame}} with all informations as extra columns.
}
\description{
Converts an object to a collection of features.
}
\examples{
## Create a count matrix
A1 <- matrix(data = as.numeric(sample(1:100, 100, TRUE)), nrow = 20)

## Coerce to compositions
B <- as_composition(A1)

## Row sums are internally stored before coercing to relative frequencies
get_totals(B)

## This allows to restore the source data
A2 <- as_amounts(B)

## Coerce to a data.frame
X <- data.frame(B)
head(X)
}
\seealso{
Other compositional data tools: 
\code{\link{as_amounts}()},
\code{\link{as_composition}()}
}
\author{
N. Frerebeau
}
\concept{compositional data tools}
