% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinner.R
\name{spinner}
\alias{spinner}
\title{Create a spinner}
\usage{
spinner(
  type = c("ring", "grow", "square", "rect"),
  size = c("l", "s"),
  color = c("default", "primary", "secondary", "info", "success", "danger", "warning")
)
}
\arguments{
\item{type}{Choose a style for the spinner using "ring","grow","square","rect"}

\item{size}{Size of the spinner, "l" for large and "s" for small}

\item{color}{Color of the spinner, choose between "default", "primary", "secondary", "info", "success", "danger", "warning"}
}
\value{
An HTML containing elements of a spinner to be embedded in a page during loading
}
\description{
Create a loading spinner for customization of outputs
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)

  shiny::shinyApp(
    ui = fluidPage(
      style = "3",
      custom.bg.color = "cyan",
      sidebar = NULL,
      header = NULL,
      card(
        header = FALSE,
        shiny::h2("loading spinner"),
        spinner(type = "rect", size = "s"),
        spinner(type = "rect", color = "primary"),
        spinner(type = "grow", color = "secondary"),
        spinner(type = "ring", color = "success"),
        spinner(type = "rect", color = "warning"),
        spinner(type = "square", color = "danger"),
        spinner(type = "rect", color = "info")
      )
    ),
    server = function(input, output) {
    }
  )
}
}

}
