library(testthat) # load testthat package
library(new.dist) # load our package
test_that("functions returns a list", {
  expect_type(dbwd(1,alpha=2,beta=1, sigma=2), "double")
  expect_type(pbwd(1,alpha=2,beta=1, sigma=2), "double")
  expect_type(qbwd(.1,alpha=2,beta=1, sigma=2), "double")
  expect_type(rbwd(1,alpha=2,beta=1, sigma=2), "double")
  expect_type(dsgrd(1,theta=2,alpha=1, beta=3), "double")
  expect_type(psgrd(1,theta=2,alpha=1, beta=3), "double")
  expect_type(qsgrd(.1,theta=2,alpha=1, beta=3), "double")
  expect_type(rsgrd(1,theta=2,alpha=1, beta=3), "double")
  expect_type(dsod(1,alpha=1, beta=2), "double")
  expect_type(psod(.2,alpha=1, beta=2), "double")
  expect_type(qsod(.1,alpha=1, beta=3), "double")
  expect_type(rsod(1,alpha=1, beta=3), "double")
  expect_type(dugd(1,theta=.5), "double")
  expect_type(pugd(1,theta=.5), "double")
  expect_type(qugd(1,theta=.5), "double")
  expect_type(rugd(1,theta=.5), "double")
  expect_type(dtpmd(1,beta=1, alpha=2), "double")
  expect_type(ptpmd(1,beta=1, alpha=2), "double")
  expect_type(qtpmd(.1,beta=1, alpha=2), "double")
  expect_type(rtpmd(1,beta=1, alpha=2), "double")
  expect_type(dtprd(2,lambda=1, mu=1), "double")
  expect_type(ptprd(2,lambda=1, mu=1), "double")
  expect_type(qtprd(.1,lambda=1, mu=1), "double")
  expect_type(rtprd(1,lambda=1, mu=2), "double")
  expect_type(duigd(1,mu=1, lambda=1), "double")
  expect_type(puigd(1,mu=1, lambda=1), "double")
  expect_type(quigd(.1,mu=1, lambda=1), "double")
  expect_type(ruigd(1,mu=1, lambda=1), "double")
  expect_type(dwgd(1,alpha=.1,lambda=1), "double")
  expect_type(pwgd(1,alpha=.1,lambda=1), "double")
  expect_type(qwgd(.1,alpha=.1,lambda=1), "double")
  expect_type(rwgd(1,alpha=.1,lambda=1), "double")
  expect_type(ddld(1,theta=1), "double")
  expect_type(pdld(1,theta=1), "double")
  expect_type(qdld(.1,theta=1), "double")
  expect_type(rdld(1,theta=1), "double")
  expect_type(ddld(1,theta=1), "double")
  expect_type(pdld(1,theta=1), "double")
  expect_type(qdld(.1,theta=1), "double")
  expect_type(rdld(1,theta=1), "double")
  expect_type(depkd(1,lambda=1,alpha=1), "double")
  expect_type(pepkd(1,lambda=1,alpha=1), "double")
  expect_type(qepkd(.1,lambda=1,alpha=1), "double")
  expect_type(repkd(1,lambda=1,alpha=1), "double")
  expect_type(dgld(1, a=1, alpha=1, beta=1), "double")
  expect_type(pgld(1, a=1, alpha=1, beta=1), "double")
  expect_type(qgld(.1, a=2, alpha=1, beta=1), "double")
  expect_type(rgld(1, a=1, alpha=1, beta=1), "double")
  expect_type(dndd(1, theta=1), "double")
  expect_type(dndd(-1, theta=1), "double")
  expect_type(dndd(-1, theta=1,log=T), "double")
  expect_type(pndd(1, theta=1), "double")
  expect_type(pndd(-1, theta=1), "double")
  expect_type(qndd(.1, theta=1), "double")
  expect_type(rndd(1, theta=1), "double")
  expect_type(dEPd(1, lambda=1,beta=1), "double")
  expect_type(pEPd(1, lambda=1,beta=1), "double")
  expect_type(qEPd(.1, lambda=1,beta=1), "double")
  expect_type(rEPd(1, lambda=1,beta=1), "double")
  expect_type(dnoPDD(1, theta=1), "double")
  expect_type(pnoPDD(1, theta=1), "double")
  expect_type(qnoPDD(.1, theta=1), "double")
  expect_type(rnoPDD(1, theta=1), "double")
  expect_type(domd(1, alpha=.1), "double")
  expect_type(pomd(1, alpha=.1), "double")
  expect_type(qomd(.1, alpha=.1), "double")
  expect_type(romd(1, alpha=.1), "double")
  expect_type(dpldd(1, alpha=1, beta=1, theta=1), "double")
  expect_type(ppldd(1, alpha=1, beta=1, theta=1), "double")
  expect_type(qpldd(.1, alpha=1, beta=1, theta=1), "double")
  expect_type(rpldd(1, alpha=1, beta=1, theta=1), "double")
  expect_type(drld(1, theta=1), "double")
  expect_type(prld(1, theta=1), "double")
  expect_type(qrld(.1, theta=1), "double")
  expect_type(rrld(1, theta=1), "double")
})
# ## Test whether the code throw an error.
test_that("functions returns errors", {
  expect_error(dbwd(5,-2,3,4), "alpha must be > 0")
  expect_error(dbwd(5,2,-3,4), "beta must be > 0")
  expect_error(pbwd(5,-2,3,4), "alpha must be > 0")
  expect_error(pbwd(5,2,-3,4), "beta must be > 0")
  expect_error(qbwd(-0.5,2,3,4),"p must be between >= 0 and <= 1")
  expect_error(qbwd(.5,-2,3,4), "alpha must be > 0")
  expect_error(qbwd(.5,2,-3,4), "beta must be > 0")
  expect_error(rbwd(-5,2,3,4),"n must be >= 1")
  expect_error(rbwd(5,-2,3,4), "alpha must be > 0")
  expect_error(rbwd(5,2,-3,4), "beta must be > 0")
  expect_error(dsgrd(2,3,-2,4), "alpha must be > -1")
  expect_error(dsgrd(2,-3,1,4), "theta must be > 0")
  expect_error(dsgrd(2,3,1,-4),"the function may not work when beta<2 since the
first and second moment does not exist!")
  expect_error(psgrd(2,3,-2,4), "alpha must be > -1")
  expect_error(psgrd(2,-3,1,4), "theta must be > 0")
  expect_error(psgrd(2,3,1,-4),"the function may not work when beta<2 since the
first and second moment does not exist!")
  expect_error(qsgrd(-0.5,2,3,4), "p must be between >= 0 and <= 1")
  expect_error(qsgrd(0.5,3,-2,4), "alpha must be > -1")
  expect_error(qsgrd(0.5,-3,1,4), "theta must be > 0")
  expect_error(qsgrd(.2,3,1,-4),"the function may not work when beta<2 since
the first and second moment does not exist!")
  expect_error(rsgrd(-5,2,3,4),"n must be >= 1")
  expect_error(rsgrd(2,3,-2,4), "alpha must be > -1")
  expect_error(rsgrd(2,-3,1,4), "theta must be > 0")
  expect_error(rsgrd(2,3,1,-4),"the function may not work when beta<2 since
the first and second moment does not exist!")
  expect_error(dsod(0.4, alpha=-1, beta=2), "alpha must be > 0")
  expect_error(dsod(0.4, alpha=1, beta=-2), "beta must be > 0")
  expect_error(psod(0.4, alpha=-1, beta=2), "alpha must be > 0")
  expect_error(psod(0.4, alpha=1, beta=-2), "beta must be > 0")
  expect_error(qsod(-0.4, alpha=1, beta=2), "p must be between >= 0 and <= 1")
  expect_error(qsod(0.4, alpha=-1, beta=2), "alpha must be > 0")
  expect_error(qsod(0.4, alpha=1, beta=-2), "beta must be > 0")
  expect_error(rsod(-10, alpha=1, beta=2),"n must be >= 1")
  expect_error(rsod(10, alpha=-1, beta=2), "alpha must be > 0")
  expect_error(rsod(10, alpha=1, beta=-2), "beta must be > 0")
  expect_error(dugd(1, theta=2), "theta must be between  0 > and < 1")
  expect_error(pugd(1, theta=2), "theta must be between  0 > and < 1")
  expect_error(qugd(-0.5, theta=.4),"p must be between >= 0 and <= 1")
  expect_error(qugd(1, theta=2), "theta must be between  0 > and < 1")
  expect_error(rugd(-10, theta=2), "n must be >= 1")
  expect_error(rugd(1, theta=2), "theta must be between  0 > and < 1")
  expect_error(dtpmd(1, beta=-2, alpha=3), "beta must be > 0")
  expect_error(dtpmd(1, beta=2, alpha=-3), "alpha must be > 0")
  expect_error(ptpmd(1, beta=-2, alpha=3), "beta must be > 0")
  expect_error(ptpmd(1, beta=2, alpha=-3), "alpha must be > 0")
  expect_error(qtpmd(2, beta=2, alpha=3), "p must be between >= 0 and <= 1")
  expect_error(qtpmd(1, beta=-2, alpha=3), "beta must be > 0")
  expect_error(qtpmd(1, beta=2, alpha=-3), "alpha must be > 0")
  expect_error(rtpmd(-10, beta=2, alpha=3), "n must be >= 1")
  expect_error(rtpmd(1, beta=-2, alpha=3), "beta must be > 0")
  expect_error(rtpmd(1, beta=2, alpha=-3), "alpha must be > 0")
  expect_error(dtprd(10, lambda=-2, mu=1), "lambda must be > 0")
  expect_error(ptprd(10, lambda=-2, mu=1), "lambda must be > 0")
  expect_error(qtprd(10, lambda=2, mu=1), "p must be between >= 0 and <= 1")
  expect_error(qtprd(.1, lambda=-2, mu=1), "lambda must be > 0")
  expect_error(rtprd(-10, lambda=2, mu=1), "n must be >= 1")
  expect_error(rtprd(10, lambda=-2, mu=1), "lambda must be > 0")
  expect_error(duigd(1, mu=-2, lambda=3), "mu must be > 0")
  expect_error(duigd(1, mu=2, lambda=-3), "lambda must be > 0")
  expect_error(puigd(1, mu=-2, lambda=3), "mu must be > 0")
  expect_error(puigd(1, mu=2, lambda=-3), "lambda must be > 0")
  expect_error(quigd(-1, mu=2, lambda=3), "p must be between >= 0 and <= 1")
  expect_error(quigd(.1, mu=-2, lambda=3), "mu must be > 0")
  expect_error(quigd(.1, mu=2, lambda=-3), "lambda must be > 0")
  expect_error(ruigd(-1, mu=2, lambda=3), "n must be >= 1")
  expect_error(ruigd(1, mu=-2, lambda=3), "mu must be > 0")
  expect_error(ruigd(1, mu=2, lambda=-3), "lambda must be > 0")
  expect_error(dwgd(1,alpha=2,lambda=3), "alpha must be between >= 0 and <= 1")
  expect_error(dwgd(1,alpha=.2,lambda=-3), "lambda must be > 0")
  expect_error(pwgd(1,alpha=2,lambda=3), "alpha must be between >= 0 and <= 1")
  expect_error(pwgd(1,alpha=.2,lambda=-3), "lambda must be > 0")
  expect_error(qwgd(-1,alpha=2,lambda=3), "p must be between >= 0 and <= 1")
  expect_error(qwgd(.1,alpha=2,lambda=3), "alpha must be between >= 0 and <= 1")
  expect_error(qwgd(.1,alpha=.2,lambda=-3), "lambda must be > 0")
  expect_error(rwgd(-1,alpha=2,lambda=3), "n must be >= 1")
  expect_error(rwgd(1,alpha=2,lambda=3), "alpha must be between >= 0 and <= 1")
  expect_error(rwgd(1, alpha=.2, lambda=-3), "lambda must be > 0")
  expect_error(ddld(1, theta = -1), "theta must be > 0")
  expect_error(pdld(1, theta = -1), "theta must be > 0")
  expect_error(qdld(10, theta = 1), "p must be between >= 0 and <= 1")
  expect_error(qdld(.1, theta = -1), "theta must be > 0")
  expect_error(rdld(-1, theta = 1), "n must be >= 1")
  expect_error(rdld(10, theta = -1), "theta must be > 0")
  expect_error(demd(1, theta = -1), "theta must be > 0")
  expect_error(pemd(1, theta = -1), "theta must be > 0")
  expect_error(qemd(10, theta = 1), "p must be between >= 0 and <= 1")
  expect_error(qemd(.1, theta = -1), "theta must be > 0")
  expect_error(remd(-1, theta = 1), "n must be >= 1")
  expect_error(remd(10, theta = -1), "theta must be > 0")
  expect_error(depkd(0.1, lambda=-2, alpha=3), "lambda must be > 0")
  expect_error(depkd(0.1, lambda=2, alpha=-3), "alpha must be > 0")
  expect_error(pepkd(0.1, lambda=-2, alpha=3), "lambda must be > 0")
  expect_error(pepkd(0.1, lambda=2, alpha=-3), "alpha must be > 0")
  expect_error(qepkd(-0.1,lambda=2,alpha=3), "p must be between >= 0 and <= 1")
  expect_error(qepkd(0.1, lambda=-2, alpha=3), "lambda must be > 0")
  expect_error(qepkd(0.1, lambda=2, alpha=-3), "alpha must be > 0")
  expect_error(repkd(0.1, lambda=2, alpha=3), "n must be >= 1")
  expect_error(repkd(10, lambda=-2, alpha=3), "lambda must be > 0")
  expect_error(repkd(10, lambda=2, alpha=-3), "alpha must be > 0")
  expect_error(dgld(1, a=-2, alpha=3, beta=4), "a must be > 0")
  expect_error(dgld(1, a=2, alpha=-3, beta=4), "alpha must be > 0")
  expect_error(dgld(1, a=2, alpha=3, beta=-4), "beta must be > 0")
  expect_error(pgld(1, a=-2, alpha=3, beta=4), "a must be > 0")
  expect_error(pgld(1, a=2, alpha=-3, beta=4), "alpha must be > 0")
  expect_error(pgld(1, a=2, alpha=3, beta=-4), "beta must be > 0")
  expect_error(qgld(2, a=2, alpha=3, beta=4), "p must be between >= 0 and <= 1")
  expect_error(qgld(.1, a=-2, alpha=3, beta=4), "a must be > 0")
  expect_error(qgld(.1, a=2, alpha=-3, beta=4), "alpha must be > 0")
  expect_error(qgld(.1, a=2, alpha=3, beta=-4), "beta must be > 0")
  expect_error(rgld(-1, a=2, alpha=3, beta=4), "n must be >= 1")
  expect_error(rgld(10, a=-2, alpha=3, beta=4), "a must be > 0")
  expect_error(rgld(10, a=2, alpha=-3, beta=4), "alpha must be > 0")
  expect_error(rgld(10, a=2, alpha=3, beta=-4), "beta must be > 0")
  expect_error(dndd(1, theta = -1), "theta must be > 0")
  expect_error(pndd(1, theta = -1), "theta must be > 0")
  expect_error(qndd(10, theta = 1), "p must be between >= 0 and <= 1")
  expect_error(qndd(.1, theta = -1), "theta must be > 0")
  expect_error(rndd(-1, theta = 1), "n must be >= 1")
  expect_error(rndd(10, theta = -1), "theta must be > 0")
  expect_error(dEPd(1, lambda=-2, beta=3), "lambda must be > 0")
  expect_error(dEPd(1, lambda=2, beta=-3), "beta must be > 0")
  expect_error(pEPd(1, lambda=-2, beta=3), "lambda must be > 0")
  expect_error(pEPd(1, lambda=2, beta=-3), "beta must be > 0")
  expect_error(qEPd(2, lambda=2, beta=-3), "p must be between >= 0 and <= 1")
  expect_error(qEPd(.1, lambda=-2, beta=3), "lambda must be > 0")
  expect_error(qEPd(.1, lambda=2, beta=-3), "beta must be > 0")
  expect_error(rEPd(-1, lambda=2, beta=3), "n must be >= 1")
  expect_error(rEPd(1, lambda=-2, beta=3), "lambda must be > 0")
  expect_error(rEPd(1, lambda=2, beta=-3), "beta must be > 0")
  expect_error(dnoPDD(1, theta = -1), "theta must be > 0")
  expect_error(pnoPDD(1, theta = -1), "theta must be > 0")
  expect_error(qnoPDD(10, theta = 1), "p must be between >= 0 and <= 1")
  expect_error(qnoPDD(.1, theta = -1), "theta must be > 0")
  expect_error(rnoPDD(-1, theta = 1), "n must be >= 1")
  expect_error(rnoPDD(10, theta = -1), "theta must be > 0")
  expect_error(domd(1, alpha=-0.2), "alpha must be > 0 and <= 1")
  expect_error(pomd(1, alpha=-0.2), "alpha must be > 0 and <= 1")
  expect_error(qomd(2, alpha=0.2), "p must be between >= 0 and <= 1")
  expect_error(qomd(.1, alpha=-0.2), "alpha must be > 0 and <= 1")
  expect_error(romd(-1, alpha=0.2), "n must be >= 1")
  expect_error(romd(1, alpha=-0.2), "alpha must be > 0 and <= 1")
  expect_error(dpldd(1, alpha=-2, beta=3, theta=4), "alpha must be > 0")
  expect_error(dpldd(1, alpha=2, beta=3, theta=-4), "theta must be >= 0")
  expect_error(ppldd(1, alpha=-2, beta=3, theta=4), "alpha must be > 0")
  expect_error(ppldd(1, alpha=2, beta=3, theta=-4), "theta must be >= 0")
  expect_error(qpldd(2,alpha=-2,beta=3,4),"p must be between >= 0 and <= 1")
  expect_error(qpldd(.1, alpha=-2, beta=3, theta=4), "alpha must be > 0")
  expect_error(qpldd(.1, alpha=2, beta=3, theta=-4), "theta must be >= 0")
  expect_error(rpldd(-1, alpha=-2, beta=3, theta=4), "n must be >= 1")
  expect_error(rpldd(10, alpha=-2, beta=3, theta=4), "alpha must be > 0")
  expect_error(rpldd(10, alpha=2, beta=3, theta=-4), "theta must be >= 0")
  expect_error(drld(1, theta = -1), "theta must be > 0")
  expect_error(prld(1, theta = -1), "theta must be > 0")
  expect_error(qrld(10, theta = 1), "p must be between >= 0 and <= 1")
  expect_error(qrld(.1, theta = -1), "theta must be > 0")
  expect_error(rrld(-1, theta = 1), "n must be >= 1")
  expect_error(rrld(10, theta = -1), "theta must be > 0")
})
# ## Test whether the output is a vector with the expected size
test_that("functions returns a  vector with the expected size", {
  expect_vector(dbwd(10, alpha=2, sigma=2), ptype = double(), size = 1)
  expect_vector(dbwd(-10, alpha=2, sigma=2), ptype = double(), size = 1)
  expect_vector(dbwd(10, alpha=2, sigma=2, log = TRUE), ptype = double(),
                size = 1)
  expect_vector(pbwd(10, alpha=2, sigma=2), ptype = double(), size = 1)
  expect_vector(pbwd(10, alpha=2, sigma=2, log.p = TRUE), ptype = double(),
                size = 1)
  expect_vector(pbwd(-10, alpha=2, sigma=2), ptype = double(), size = 1)
  expect_vector(pbwd(10, alpha=2, sigma=2, lower.tail = FALSE),
                ptype = double(),size = 1)
  expect_vector(qbwd(.10, alpha=2, sigma=2, lower.tail = FALSE),
                ptype = double(),size = 1)
  expect_vector(qbwd(.10, alpha=2, sigma=2), ptype = double(), size = 1)
  expect_vector(rbwd(10, alpha=2, sigma=2), ptype = double(), size = 10)
  expect_vector(dsgrd(2, theta=3, alpha=1, beta=4), ptype = double(), size = 1)
  expect_vector(dsgrd(-2, theta=3, alpha=1, beta=4), ptype = double(), size = 1)
  expect_vector(dsgrd(2, theta=3, alpha=1, beta=4, log = T), ptype = double(),
                size = 1)
  expect_vector(dsgrd(-2, theta=3, alpha=1, beta=4, log = T), ptype = double(),
                size = 1)
  expect_vector(psgrd(2, theta=3, alpha=1,beta =4), ptype = double(), size = 1)
  expect_vector(psgrd(-2, theta=3, alpha=1,beta =4), ptype = double(), size = 1)
  expect_vector(psgrd(2, theta=3, alpha=1,beta =4, log.p = T), ptype = double(),
                size = 1)
  expect_vector(psgrd(2, theta=3, alpha=1, beta=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qsgrd(.2,theta=3,alpha=1,beta=4), ptype = double(), size = 1)
  expect_vector(qsgrd(.2, theta=3, alpha=1, beta=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rsgrd(20, theta=3, alpha=1,beta=4), ptype = double(), size = 20)
  expect_vector(dsod(0.4, alpha=1, beta=2), ptype = double(), size = 1)
  expect_vector(dsod(0.4, alpha=1, beta=2, log = T), ptype = double(), size = 1)
  expect_vector(psod(0.4, alpha=1, beta=2), ptype = double(), size = 1)
  expect_vector(psod(1, alpha=1, beta=2), ptype = double(), size = 1)
  expect_vector(psod(0.4, alpha=1, beta=2, log.p = T),
                ptype = double(), size = 1)
  expect_vector(psod(0.4, alpha=1, beta=2, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qsod(0.4, alpha=1, beta=2), ptype = double(), size = 1)
  expect_vector(qsod(0.4, alpha=1, beta=2, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rsod(20, alpha=1, beta=2), ptype = double(), size = 20)
  expect_vector(dugd(1, theta=0.5), ptype = double(), size = 1)
  expect_vector(dugd(-1, theta=0.5), ptype = double(), size = 1)
  expect_vector(dugd(1, theta=0.5, log=T), ptype = double(), size = 1)
  expect_vector(pugd(1, theta=0.5), ptype = double(), size = 1)
  expect_vector(pugd(1, theta=0.5, lower.tail=F), ptype = double(), size = 1)
  expect_vector(pugd(1, theta=0.5, log.p=T), ptype = double(), size = 1)
  expect_vector(qugd(.1, theta=0.5), ptype = double(), size = 1)
  expect_vector(qugd(.1, theta=0.5, lower.tail = F), ptype = double(), size = 1)
  expect_vector(rugd(20, theta=0.5), ptype = double(), size = 20)
  expect_vector(dtpmd(1, beta=2, alpha=3), ptype = double(), size = 1)
  expect_vector(dtpmd(-1, beta=2, alpha=3), ptype = double(), size = 1)
  expect_vector(dtpmd(1, beta=2, alpha=3, log=T), ptype = double(), size = 1)
  expect_vector(ptpmd(1, beta=2, alpha=3), ptype = double(), size = 1)
  expect_vector(ptpmd(-1, beta=2, alpha=3), ptype = double(), size = 1)
  expect_vector(ptpmd(1, beta=2, alpha=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(ptpmd(1, beta=2, alpha=3, log.p = T),
                ptype = double(), size = 1)
  expect_vector(qtpmd(.1, beta=2, alpha=3), ptype = double(), size = 1)
  expect_vector(qtpmd(.1, beta=2, alpha=3,lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rtpmd(20, beta=2, alpha=3), ptype = double(), size = 20)
  expect_vector(dtprd(5, lambda=4, mu=4), ptype = double(), size = 1)
  expect_vector(dtprd(3, lambda=4, mu=4), ptype = double(), size = 1)
  expect_vector(dtprd(5, lambda=4, mu=4, log = T), ptype = double(), size = 1)
  expect_vector(ptprd(5, lambda=4, mu=4), ptype = double(), size = 1)
  expect_vector(ptprd(3, lambda=4, mu=4), ptype = double(), size = 1)
  expect_vector(ptprd(5, lambda=4, mu=4, log.p = T), ptype = double(), size = 1)
  expect_vector(ptprd(5, lambda=4, mu=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qtprd(.5, lambda=4, mu=4), ptype = double(), size = 1)
  expect_vector(qtprd(.5, lambda=4, mu=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rtprd(20, lambda=4, mu=4), ptype = double(), size = 20)
  expect_vector(duigd(1, mu=2, lambda=3), ptype = double(), size = 1)
  expect_vector(duigd(-1, mu=2, lambda=3), ptype = double(), size = 1)
  expect_vector(duigd(1, mu=2, lambda=3, log = T), ptype = double(), size = 1)
  expect_vector(puigd(1, mu=2, lambda=3), ptype = double(), size = 1)
  expect_vector(puigd(-1, mu=2, lambda=3), ptype = double(), size = 1)
  expect_vector(puigd(1, mu=2, lambda=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(puigd(1, mu=2, lambda=3, log.p = T), ptype = double(), size = 1)
  expect_vector(quigd(.1, mu=2, lambda=3), ptype = double(), size = 1)
  expect_vector(quigd(.1, mu=2, lambda=3,lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(ruigd(20, mu=2, lambda=3), ptype = double(), size = 20)
  expect_vector(dwgd(1, alpha=.2, lambda=3), ptype = double(), size = 1)
  expect_vector(dwgd(-1, alpha=.2, lambda=3), ptype = double(), size = 1)
  expect_vector(dwgd(1, alpha=.2, lambda=3, log=T), ptype = double(), size = 1)
  expect_vector(pwgd(1, alpha=.2, lambda=3), ptype = double(), size = 1)
  expect_vector(pwgd(1, alpha=.2, lambda=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(pwgd(1, alpha=.2, lambda=3, log.p = T),
                ptype = double(), size = 1)
  expect_vector(qwgd(.1, alpha=.2, lambda=3), ptype = double(), size = 1)
  expect_vector(qwgd(.1, alpha=.2, lambda=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rwgd(20, alpha=.2, lambda=3), ptype = double(), size = 20)
  expect_vector(ddld(1, theta=0.5), ptype = double(), size = 1)
  expect_vector(ddld(-1, theta=0.5), ptype = double(), size = 1)
  expect_vector(ddld(1, theta=0.5,log=T), ptype = double(), size = 1)
  expect_vector(pdld(1, theta=0.5), ptype = double(), size = 1)
  expect_vector(pdld(-1, theta=0.5), ptype = double(), size = 1)
  expect_vector(pdld(1, theta=0.5, lower.tail = F), ptype = double(), size = 1)
  expect_vector(pdld(1, theta=0.5, log.p = T), ptype = double(), size = 1)
  expect_vector(qdld(.1, theta=0.5), ptype = double(), size = 1)
  expect_vector(qdld(0.1, theta=0.5, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rdld(20, theta=0.5), ptype = double(), size = 20)
  expect_vector(demd(1, theta=0.5), ptype = double(), size = 1)
  expect_vector(demd(-1, theta=0.5), ptype = double(), size = 1)
  expect_vector(demd(1, theta=0.5, log=T), ptype = double(), size = 1)
  expect_vector(pemd(1, theta=0.5), ptype = double(), size = 1)
  expect_vector(pemd(-1, theta=0.5), ptype = double(), size = 1)
  expect_vector(pemd(1, theta=0.5, lower.tail = F), ptype = double(), size = 1)
  expect_vector(pemd(1, theta=0.5, log.p = T), ptype = double(), size = 1)
  expect_vector(qemd(.1, theta=0.5), ptype = double(), size = 1)
  expect_vector(qemd(.1, theta=0.5, lower.tail = F), ptype = double(), size = 1)
  expect_vector(remd(20, theta=0.5), ptype = double(), size = 20)
  expect_vector(depkd(0.1, lambda=2, alpha=3), ptype = double(), size = 1)
  expect_vector(depkd(0.1, lambda=2, alpha=3, log = T),
                ptype = double(), size = 1)
  expect_vector(pepkd(0.1, lambda=2, alpha=3), ptype = double(), size = 1)
  expect_vector(pepkd(0.1, lambda=2, alpha=3, log.p = T),
                ptype = double(), size = 1)
  expect_vector(pepkd(0.1, lambda=2, alpha=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qepkd(0.1, lambda=2, alpha=3), ptype = double(), size = 1)
  expect_vector(qepkd(0.1, lambda=2, alpha=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(repkd(20, lambda=2,alpha=3), ptype = double(), size = 20)
  expect_vector(dgld(1, a=2, alpha=3, beta=4), ptype = double(), size = 1)
  expect_vector(dgld(-1, a=2, alpha=3, beta=4), ptype = double(), size = 1)
  expect_vector(dgld(1, a=2, alpha=3, beta=4, log = T),
                ptype = double(), size = 1)
  expect_vector(pgld(1, a=2, alpha=3, beta=4), ptype = double(), size = 1)
  expect_vector(pgld(-1, a=2, alpha=3, beta=4), ptype = double(), size = 1)
  expect_vector(pgld(1, a=2, alpha=3, beta=4, log.p = T),
                ptype = double(), size = 1)
  expect_vector(pgld(1, a=2, alpha=3, beta=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qgld(.1, a=2, alpha=3, beta=4), ptype = double(), size = 1)
  expect_vector(qgld(.1, a=2, alpha=3, beta=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qgld(.1, a=2, alpha=3, beta=4, lower.tail = T),
                ptype = double(), size = 1)
  expect_vector(rgld(20, a=2, alpha=3, beta=4), ptype = double(), size = 20)
  expect_vector(dndd(.5,theta=2), ptype = double(), size = 1)
  expect_vector(pndd(.5,theta=2), ptype = double(), size = 1)
  expect_vector(pndd(.5,theta=2,lower.tail=F), ptype = double(), size = 1)
  expect_vector(pndd(.5,theta=2,log.p=T), ptype = double(), size = 1)
  expect_vector(pndd(-5,theta=2,log.p=F), ptype = double(), size = 1)
  expect_vector(qndd(.5,theta=2), ptype = double(), size = 1)
  expect_vector(qndd(c(.5,.2),theta=c(2,3),lower.tail=F),
                ptype = double(), size = 2)
  expect_vector(rndd(20,theta=2), ptype = double(), size = 20)
  expect_vector(dEPd(1, lambda=2, beta=3), ptype = double(), size = 1)
  expect_vector(dEPd(-1, lambda=2, beta=3), ptype = double(), size = 1)
  expect_vector(dEPd(1, lambda=2, beta=3, log = T), ptype = double(), size = 1)
  expect_vector(pEPd(1, lambda=2, beta=3), ptype = double(), size = 1)
  expect_vector(pEPd(-1, lambda=2, beta=3), ptype = double(), size = 1)
  expect_vector(pEPd(1, lambda=2, beta=3, log.p = T),
                ptype = double(), size = 1)
  expect_vector(pEPd(1, lambda=2, beta=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(qEPd(.1, lambda=2, beta=3), ptype = double(), size = 1)
  expect_vector(qEPd(.1, lambda=2, beta=3, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rEPd(20, lambda=2, beta=3), ptype = double(), size = 20)
  expect_vector(dnoPDD(1,theta=2), ptype = double(), size = 1)
  expect_vector(dnoPDD(-1,theta=2), ptype = double(), size = 1)
  expect_vector(dnoPDD(1, theta=2, log = T), ptype = double(), size = 1)
  expect_vector(pnoPDD(1, theta=2), ptype = double(), size = 1)
  expect_vector(pnoPDD(1, theta=2, lower.tail = F), ptype = double(), size = 1)
  expect_vector(pnoPDD(1, theta=2, log.p = T), ptype = double(), size = 1)
  expect_vector(pnoPDD(-1, theta=2, log.p = T), ptype = double(), size = 1)
  expect_vector(qnoPDD(.1, theta=2), ptype = double(), size = 1)
  expect_vector(qnoPDD(.1, theta=2, lower.tail = F), ptype = double(), size = 1)
  expect_vector(rnoPDD(20,theta=2), ptype = double(), size = 20)
  expect_vector(domd(.8, alpha=.1), ptype = double(), size = 1)
  expect_vector(domd(-.8, alpha=.1), ptype = double(), size = 1)
  expect_vector(domd(.8, alpha=.1, log = T), ptype = double(), size = 1)
  expect_vector(pomd(.8, alpha=.1), ptype = double(), size = 1)
  expect_vector(pomd(-.8, alpha=.1), ptype = double(), size = 1)
  expect_vector(pomd(.8, alpha=.1, log.p = T), ptype = double(), size = 1)
  expect_vector(pomd(.8, alpha=.1, lower.tail = F), ptype = double(), size = 1)
  expect_vector(qomd(.8, alpha=.1), ptype = double(), size = 1)
  expect_vector(qomd(.8, alpha=.1, lower.tail = F), ptype = double(), size = 1)
  expect_vector(romd(20, alpha=.1), ptype = double(), size = 20)
  expect_vector(dpldd(1, alpha=2, beta=3, theta=4), ptype = double(), size = 1)
  expect_vector(dpldd(1, alpha=2, beta=3, theta=4, log = T),
                ptype = double(), size = 1)
  expect_vector(ppldd(1, alpha=2, beta=3, theta=4), ptype = double(), size = 1)
  expect_vector(ppldd(1, alpha=2, beta=3, theta=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(ppldd(1, alpha=2, beta=3, theta=4, log.p = T),
                ptype = double(), size = 1)
  expect_vector(qpldd(.1, alpha=2, beta=3, theta=4), ptype = double(), size = 1)
  expect_vector(qpldd(.1, alpha=2, beta=3, theta=4, lower.tail = F),
                ptype = double(), size = 1)
  expect_vector(rpldd(20, alpha=2, beta=3, theta=4), ptype = double(),
                size = 20)
  expect_vector(drld(1, theta=5), ptype = double(), size = 1)
  expect_vector(drld(-1, theta=5), ptype = double(), size = 1)
  expect_vector(drld(1, theta=5, log=T), ptype = double(), size = 1)
  expect_vector(prld(1, theta=5), ptype = double(), size = 1)
  expect_vector(prld(-1, theta=5), ptype = double(), size = 1)
  expect_vector(prld(1, theta=5, log.p = T), ptype = double(), size = 1)
  expect_vector(prld(1, theta=5, lower.tail = F), ptype = double(), size = 1)
  expect_vector(qrld(.1, theta=5), ptype = double(), size = 1)
  expect_vector(qrld(.1, theta=5, lower.tail = F), ptype = double(), size = 1)
  expect_vector(rrld(20, theta=5), ptype = double(), size = 20)
})
