% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noPDD.R
\name{noPDD}
\alias{noPDD}
\alias{dnoPDD}
\alias{pnoPDD}
\alias{qnoPDD}
\alias{rnoPDD}
\title{A new one parameter discrete distribution and its applications}
\usage{
dnoPDD(x, theta = 1, log = FALSE)

pnoPDD(q, theta = 1, lower.tail = TRUE, log.p = FALSE)

qnoPDD(p, theta = 1, lower.tail = TRUE)

rnoPDD(n, theta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise,\eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dnoPDD} gives the density, \code{pnoPDD} gives the distribution
function, \code{qnoPDD} gives the quantile function and \code{rnoPDD}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
a new one parameter discrete distribution with parameter \code{scale}.
}
\details{
A new one parameter discrete distribution with \code{scale} parameter
\eqn{\theta}, has density given by
\deqn{f\left( x\right) =\frac{\theta ^{6}}{\theta ^{6}+120}
 \left( \theta+x^{5}\right) e^{-\theta x},}
where
\deqn{x>0,~\theta >0.}
}
\examples{
library(new.dist)
dnoPDD(1,theta=2)
pnoPDD(1,theta=2)
qnoPDD(.1,theta=1)
rnoPDD(10,theta=1)
}
\references{
Shukla, K. K., Shanker, R. ve Tiwari, M. K., 2022,
\emph{A new one parameter discrete distribution and its applications}, Journal
of Statistics and Management Systems, 25 (1), 269-283.
}
