% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_query_voxel.R
\name{nv_atlas_voxel}
\alias{nv_atlas_voxel}
\title{Neurovault Atlas Query Voxel}
\usage{
nv_atlas_voxel(x, y, z, collection_name, atlas_name, verbose = TRUE,
  secure = TRUE, ...)
}
\arguments{
\item{x}{x-coordinate to query}

\item{y}{y-coordinate to query}

\item{z}{z-coordinate to query}

\item{collection_name}{Collection name of the atlas}

\item{atlas_name}{Name of the atlas}

\item{verbose}{print diagnostic messages}

\item{secure}{passed to \code{\link{nv_base_url}} for https}

\item{...}{additional options to pass to \code{\link{GET}}}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Searches atlas and returns
the region name that matches the specified coordinates
in the specified atlas.
Coordinates are in mm in MNI space.
}
\examples{
res = nv_atlas_voxel(x = 30, y= 30, z = 30,
collection_name = "Harvard-Oxford cortical and subcortical structural atlases",
atlas_name = "HarvardOxford cort maxprob thr25 1mm")
head(res$content$voxels)
}
