% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.NeuralGAM.R
\name{plot.neuralGAM}
\alias{plot.neuralGAM}
\title{Visualization of \code{neuralGAM} object with base graphics}
\usage{
\method{plot}{neuralGAM}(x, select = NULL, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{a fitted \code{neuralGAM} object as produced by \code{neuralGAM()}.}

\item{select}{allows to plot a set of selected terms. e.g. if you just want to plot the first term,
select="X0"}

\item{xlab}{if supplied, this value will be used as the \code{x} label for all plots}

\item{ylab}{if supplied, this value will be used as the \code{y} label for all plots}

\item{\ldots}{other graphics parameters to pass on to plotting commands.}
}
\value{
Returns the partial effects plot.
}
\description{
Visualization of \code{neuralGAM} object. Plots the learned partial effects by the neuralGAM object.
}
\examples{
\donttest{

n <- 24500

seed <- 42
set.seed(seed)

x1 <- runif(n, -2.5, 2.5)
x2 <- runif(n, -2.5, 2.5)
x3 <- runif(n, -2.5, 2.5)

f1 <-x1**2
f2 <- 2*x2
f3 <- sin(x3)
f1 <- f1 - mean(f1)
f2 <- f2 - mean(f2)
f3 <- f3 - mean(f3)

eta0 <- 2 + f1 + f2 + f3
epsilon <- rnorm(n, 0.25)
y <- eta0 + epsilon
train <- data.frame(x1, x2, x3, y)

library(neuralGAM)
ngam <- neuralGAM(y ~ s(x1) + x2 + s(x3), data = train,
                 num_units = 1024, family = "gaussian",
                 activation = "relu",
                 learning_rate = 0.001, bf_threshold = 0.001,
                 max_iter_backfitting = 10, max_iter_ls = 10,
                 seed = seed
                 )
plot(ngam)
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
