% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDSnet.R
\name{PROCRUSTESnet}
\alias{PROCRUSTESnet}
\title{PROCRUSTESnet}
\usage{
PROCRUSTESnet(qgraph_net1, qgraph_net2, type1 = c("ordinal", "interval",
  "ratio", "mspline"), type2 = type1, MDSadj1 = NULL, MDSadj2 = NULL,
  stressTxt = F, congCoef = F, repulse = F, repulsion = 1,
  mdsArgs = list(), ...)
}
\arguments{
\item{qgraph_net1}{an object of type \code{qgraph}}

\item{qgraph_net2}{an object of type \code{qgraph}. Contains the same nodes as \code{qgraph_net2}}

\item{type1}{transformation function for first MDS, defaults to "ordinal"}

\item{type2}{transformation function for second MDS, defaults to the same as \code{type1}}

\item{MDSadj1}{to use a proximities matrix other than the adjacency matrix
stored in \code{qgraph_net1}, provide it in this argument}

\item{MDSadj2}{to use a proximities matrix other than the adjacency matrix
stored in \code{qgraph_net2}, provide it in this argument}

\item{stressTxt}{logical. Print the stress value in the lower left corner of the plots?}

\item{congCoef}{logical. Print the congruence coefficient fo the two layouts?}

\item{repulse}{logical. Add a small repulsion force with wordcloud package to avoid node overlap?}

\item{repulsion}{scalar for the repulsion force. Larger values add more repulsion}

\item{mdsArgs}{additional arguments in list format passed to \code{smacof::mds}}

\item{...}{additional arguments passed to \code{qgraph}}
}
\description{
Convenience function for simultaneously plotting two networks containing the same nodes.
}
\details{
Each network's layout is determined by multidimensional scaling, and then the layouts
are brought into a similar space by using the Procrustes algorithm.



A network plotted with multidimensional scaling can be interpreted based on the distances
between nodes. Nodes close together represent closely associated nodes, whereas nodes that are far
apart represent unassociated or negatively associated nodes.

The Procrustes algorithm brings the two layouts into a similar space through rotations and dilations
that do not impact the fit of the MDS solutions. In this implementation, the second network is rotated
and dilated to fit the first.
}
\references{
Jones, P. J., Mair, P., & McNally, R. J. (2018). Visualizing psychological networks: A tutorial in R. Frontiers in Psychology, 9, 1742. https://doi.org/10.3389/fpsyg.2018.01742
}
