% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\name{abc}
\alias{abc}
\title{ABC algorithm for network reverse-engineering}
\usage{
abc(
  data,
  clust_coeffs = c(0.33, 0.66, 1),
  tolerance = NA,
  number_hubs = NA,
  iterations = 10,
  number_networks = 1000,
  hub_probs = NA,
  neighbour_probs = NA,
  is_probs = 1
)
}
\arguments{
\item{data}{: Any microarray data in the form of a matrix (rows are genes and columns are time points)}

\item{clust_coeffs}{: one dimensional array of size clust_size of clustering coefficients (these clustering coefficient are tested in the ABc algorithm).}

\item{tolerance}{: a positive real value based for the tolerance between the generated networks and the reference network}

\item{number_hubs}{: number of hubs in the network}

\item{iterations}{: number of times to repeat ABC algorithm}

\item{number_networks}{: number of generated networks in each iteration of the ABC algorithm}

\item{hub_probs}{: one-dimensional array of size number_genes for the each label to be in the role of a hub}

\item{neighbour_probs}{: this is the matrix of neighbour probabilities of size number_nodes*number_nodes}

\item{is_probs}{: this needs to be set either to one (if you specify hub_probs and neighbour_probs) or to zero (if neither probabilities are specified). Warning: you should specify both hub_probs and neighbour_probs if is_probs is one. If is_prob is zero these arrays should simply indicate an array of a specified size..}
}
\description{
ABC algorithm for network reverse-engineering
}
\examples{
M<-matrix(rnorm(30),10,3)
result<-abc(data=M)
}
