\name{network.edgecount}
\alias{network.edgecount}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Return the Number of Edges in a Network Object }
\description{
  \code{network.edgecount} returns the number of edges within a \code{network}, removing those flagged as missing if desired.
}
\usage{
network.edgecount(x, na.omit = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ an object of class \code{network} }
  \item{na.omit}{ logical; omit edges with \code{na==TRUE} from the count? }
}
\details{
  The return value \code{network.edgecount} is equal to \code{g$gal$mnext}-1, minus the number of \code{NULL} edges (and missing edges, if \code{na.omit==TRUE}).  Note that \code{g$gal$mnext}-1 cannot, by itself, be counted upon to be an accurate count of the number of edges!
}
\value{
  The number of edges
}
\references{ Butts, C.T.  2002.  ``Memory Structures for Relational Data in R: Classes and Interfaces''  Working Paper. }
\author{ Carter T. Butts \email{buttsc@uci.edu} }
%\note{ ~~further notes~~ }
%
% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{get.network.attribute}} }
\examples{
#Create a network with three edges
m<-matrix(0,3,3)
m[1,2]<-1; m[2,3]<-1; m[3,1]<-1
g<-network(m)
network.edgecount(g)==3   #Verify the edgecount
}
\keyword{ classes }% at least one, from doc/KEYWORDS
\keyword{ graphs }% __ONLY ONE__ keyword per line
