% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_ops.R
\name{invert_exchangeable_matrix}
\alias{invert_exchangeable_matrix}
\title{Invert an exchangeable matrix}
\usage{
invert_exchangeable_matrix(n, phi, directed = TRUE)
}
\arguments{
\item{n}{Number of actors in the network, scalar numeric.}

\item{phi}{Appropriate-length vector of parameters, must be length 5 or 6 for directed=\code{TRUE} or length 2 or 3 for directed=\code{FALSE}.}

\item{directed}{Optional logical indicator of whether input data is for a directed network, default is \code{TRUE}. Undirected data format is lower triangle of adjacencey matrix.}
}
\value{
\item{out}{Parameters of inverted matrix of exchangeable class.}
}
\description{
Invert an exchangeable matrix
}
\details{
This function inverts a covariance matrix of the excahgneable class in a manner much faster than the direct inverse, and the computational cost does not scale with n. See Marrs (2017). This approach will only work for complete networks.
}
\examples{
n <- 10
phi <- rphi(n, seed=1)
p <- invert_exchangeable_matrix(n, phi)
I1 <- build_exchangeable_matrix(n, phi) \%*\% build_exchangeable_matrix(n, p)
range(I1 -  diag(n*(n-1)))   # it works

}
\references{
Marrs, F. W., McCormick, T. H., & Fosdick, B. K. (2017). Standard errors for regression on relational data with exchangeable errors. arXiv preprint arXiv:1701.05530.
}
\seealso{
\code{\link{rphi}}, \code{\link{build_exchangeable_matrix}}
}
\keyword{external}
