% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_ops.R
\name{rphi}
\alias{rphi}
\title{Generate positive definite phi set}
\usage{
rphi(n, seed = NULL, phi6 = FALSE, directed = TRUE)
}
\arguments{
\item{n}{Number of actors in the network, scalar numeric.}

\item{seed}{Optional numeric seed to set, default is \code{NULL}.}

\item{phi6}{Optional logical indicator of whether sixth parameter \eqn{\phi_6} should be considered nonzero. Default is \code{FALSE}.}

\item{directed}{Optional logical indicator of whether input data is for a directed network, default is \code{TRUE}. Undirected data format is lower triangle of adjacencey matrix.}
}
\value{
\item{phi}{Vector of parameters.}
}
\description{
Generate positive definite phi set
}
\details{
This function generates a set of 5 (or 6, as appropriate) parameters that corresponds to positive definite exchangeable covariance matrix for a network of size \code{n}. See Marrs (2017).
}
\examples{
rphi(10, seed=1)

}
\references{
Marrs, F. W., McCormick, T. H., & Fosdick, B. K. (2017). Standard errors for regression on relational data with exchangeable errors. arXiv preprint arXiv:1701.05530.
}
\seealso{
\code{\link{build_exchangeable_matrix}}, \code{\link{invert_exchangeable_matrix}}
}
\keyword{external}
