% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netgraph.R
\name{netgraph}
\alias{netgraph}
\title{Generic function for network graphs}
\usage{
netgraph(x, ...)
}
\arguments{
\item{x}{An R object.}

\item{\dots}{Additional arguments.}
}
\description{
Generic function for network graphs
}
\details{
For more details, look at the following functions to generate
network graphs:
\itemize{
\item \code{\link{netgraph.netmeta}}
\item \code{\link{netgraph.netimpact}}
\item \code{\link{netgraph.netconnection}}
\item \code{\link{netgraph.netcomb}}
\item \code{\link{netgraph.discomb}}
}
}
\examples{
data(smokingcessation)

# Transform data from arm-based format to contrast-based format
#
pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

# Conduct random effects network meta-analysis
#
net1 <- netmeta(pw1, common = FALSE)

# Network graph with default settings
#
netgraph(net1)

\donttest{
data(Senn2013)

# Network graphs with default settings
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD", reference = "plac")
netgraph(net2)
#
pw3 <- pairwise(treatment, event = r, n = N,
  studlab = author, data = dat.woods2010, sm = "OR")
net3 <- netmeta(pw3)
netgraph(net3)

# Network graph with number of participants for each treatment arm
#
netgraph(net3, labels = paste0(trts, " (n=", n.trts, ")"))
}

}
\seealso{
\code{\link[metadat]{dat.woods2010}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de
}
}
\keyword{hplot}
