% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netpairwise.R
\name{netpairwise}
\alias{netpairwise}
\alias{print.netpairwise}
\alias{summary.netpairwise}
\alias{print.summary.netpairwise}
\alias{forest.netpairwise}
\alias{plot.netpairwise}
\title{Conduct pairwise meta-analyses for all comparisons with direct
evidence in a network meta-analysis}
\usage{
netpairwise(
  x,
  separate = FALSE,
  common = x$common,
  random = x$random,
  level = x$level,
  level.ma = x$level.ma,
  prediction = x$prediction,
  level.predict = x$level.predict,
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  method.tau = x$method.tau,
  sep.trts = x$sep.trts,
  nchar.trts = x$nchar.trts,
  backtransf = x$backtransf,
  warn.deprecated = gs("warn.deprecated"),
  ...
)

\method{print}{netpairwise}(x, ...)

\method{summary}{netpairwise}(object, ...)

\method{print}{summary.netpairwise}(x, ...)

\method{forest}{netpairwise}(x, ...)

\method{plot}{netpairwise}(x, ...)
}
\arguments{
\item{x}{An object of class \code{netmeta} or \code{netpairwise}.}

\item{separate}{A logical indicating whether results for pairwise
comparisons should be printed as separate meta-analyses or as
subgroups which is more concise.}

\item{common}{A logical indicating whether a common effects network
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects network
meta-analysis should be conducted.}

\item{level}{The level used to calculate confidence intervals for
individual comparisons.}

\item{level.ma}{The level used to calculate confidence intervals
for pooled estimates.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{level.predict}{The level used to calculate prediction
intervals for a new study.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"REML"}, or
\code{"ML"}, can be abbreviated.}

\item{sep.trts}{A character used in comparison names as separator
between treatment labels.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names (see Details).}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (passed on to \code{metagen} or
print functions and to catch deprecated arguments).}

\item{object}{An object of class \code{netpairwise}.}
}
\value{
Either a single \code{\link{metagen}} object with pairwise
comparisons as subgroups or a list with \code{\link{metagen}}
objects for each direct pairwise comparison.
}
\description{
Conduct pairwise meta-analyses for all comparisons with direct
evidence in a network meta-analysis.
}
\details{
Conduct pairwise meta-analyses for all comparisons with direct
evidence in a network meta-analysis. In contrast to
\code{\link{netmeta}} and \code{\link{netsplit}}, unadjusted
standard errors are used in the calculations and the between-study
heterogeneity variance is allowed to differ between comparisons.

The R function \code{\link{metagen}} is called internally.
}
\note{
This function must not be confused with \code{\link{pairwise}}
which can be used as a pre-processing step to convert data from
arm-based to contrast-based format by calculating all pairwise
comparisons within a study.
}
\examples{
oldsets <- settings.meta(digits = 2, digits.tau2 = 2, digits.tau = 2)

data(smokingcessation)

# Transform data from arm-based format to contrast-based format
#
p1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

# Conduct random effects network meta-analysis
#
net1 <- netmeta(p1, common = FALSE)

# Calculate and print concise results for all pairwise
# meta-analyses
#
np1 <- netpairwise(net1)
np1
print(np1, details.method = FALSE)

\dontrun{
data(Senn2013)

# Random effects model
#
net2 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", common = FALSE)

# Calculate and print concise results for all pairwise
# meta-analyses
#
np2 <- netpairwise(net2)
np2
print(np2, details.method = FALSE)

forest(np2)

# Print detailed information for each pairwise comparison
#
np3 <- netpairwise(net2, separate = TRUE)
forest(np3)
}

settings.meta(oldsets)

}
\seealso{
\code{\link{netmeta}}, \code{\link{netsplit}},
  \code{\link{pairwise}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
