% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.decomp.design.R
\name{print.decomp.design}
\alias{print.decomp.design}
\title{Print method for objects of class decomp.design}
\usage{
\method{print}{decomp.design}(
  x,
  digits.Q = gs("digits.Q"),
  showall = FALSE,
  digits.pval.Q = gs("digits.pval.Q"),
  digits.tau2 = gs("digits.tau2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  nchar.trts = x$nchar.trts,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{decomp.design}.}

\item{digits.Q}{Minimal number of significant digits for Q
statistics, see \code{print.default}.}

\item{showall}{A logical indicating whether results should be shown
for all designs or only designs contributing to chi-squared
statistics (default).}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity tests, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{\dots}{Additional arguments (ignored at the moment).}
}
\description{
Print method for objects of class \code{decomp.design}.
}
\examples{
data(Senn2013)

# Only consider first five studies (to reduce runtime of example)
#
studies <- unique(Senn2013$studlab)
Senn2013.5 <- subset(Senn2013, studlab \%in\% studies[1:5])

# Conduct network meta-analysis with placebo as reference treatment
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013.5, sm = "MD", reference = "plac")

# Decomposition of Cochran's Q
#
decomp.design(net1)

}
\seealso{
\code{\link{decomp.design}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}, Ulrike
  Krahn \email{ulrike.krahn@bayer.com}
}
\keyword{print}
