% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplotNetwork.R
\name{autoplot.Network}
\alias{autoplot.Network}
\title{Autoplot function.}
\usage{
\method{autoplot}{Network}(object, path = NULL, close.path = FALSE,
  path.colour = "gray", use.opt.tour = FALSE, ...)
}
\arguments{
\item{object}{[\code{Network}]\cr
Network.}

\item{path}{[\code{integer}]\cr
An integer vector containing the order of cities of a path or a list
of multiple paths. Keep in mind
that instances with \eqn{n} nodes and \eqn{m} depots have \eqn{n + m}
coordinates, with the \eqn{1,\ldots,m} first coordinates belonging to
the depots.}

\item{close.path}{[\code{logical(1)}]\cr
Logical indicating whether the path passed by \code{path} should be
closed to a cycle. Default is \code{FALSE}.}

\item{path.colour}{[\code{character(1)}]\cr
Colour of the lines linking nodes on a path. Default is \dQuote{gray}.}

\item{use.opt.tour}{[\code{logical(1)}]\cr
If the given network knows its optimal tour, should it be plotted?
If this is the case and \code{path} is given additionally, the optimal
tour is ignored.
Default is \code{FALSE}.}

\item{...}{[any]\cr
Currently not used.}
}
\value{
[\code{\link[ggplot2]{ggplot}}]
}
\description{
Generates a \code{\link[ggplot2]{ggplot}} object. Nice possibility to
visualize 2-dimensional (clustered) networks in the euclidean plane.
}
\examples{
\dontrun{
# here we have no depots ...
x = generateClusteredNetwork(n.points = 30L, n.cluster = 2L)
pl = autoplot(x, path = 1:3)
# ... and here we have two depots: the path visits the depots in this case
x = generateRandomNetwork(n.points = 30L, n.depots = 2L)
pl = autoplot(x, path = 1:3, path.colour = "tomato")
}
}
