% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_foreign.r
\name{read_pajek}
\alias{read_pajek}
\alias{read_net}
\alias{read_dl}
\alias{read_ml}
\title{Read foreign graph formats}
\source{
From the pajek manual \url{http://mrvar.fdv.uni-lj.si/pajek/pajekman.pdf}
}
\usage{
read_pajek(x)

read_ml(x)
}
\arguments{
\item{x}{Character scalar. Path to the file to be imported.}
}
\value{
In the case of \code{read_pajek}, a list with three elements
\item{vertices}{A data frame with \eqn{n} rows and two columns: id and label}
\item{edges}{If not null, a list of data frames with three columns: ego, alter, w (weight)}
\item{edgelist}{If not null, a list of data frame with three columns: ego, alter, w (weight)}

For \code{read_ml}, a list with two elements:
\item{adjmat}{An array with the graph}
\item{meta}{A list with metadata}
}
\description{
Reading pajek and Ucinet files, this function returns weighted edgelists in the form of
data frames including a data frame of the vertices. (function on development)

Read UCINET graph files
Other datasets http://moreno.ss.uci.edu/data.html
}
\details{
Since .net files allow working with multi-relational networks (more than one
class of edge), the function returns lists of edges and edgeslist with the corresponding
tag on the .net file. For example, if the .net file contains

\preformatted{
 *Arcslist :9 "SAMPPR"
 ...
 *Arcslist :10 "SAMNPR"
}

The output will include data frames of edgelists with those tags.
}
\examples{
# From .net: Sampson monastery data from UCINET dataset ---------------------

# Reading the arcs/edges format
path <- system.file("extdata", "SAMPSON.NET", package = "netdiffuseR")
SAMPSON <- read_pajek(path)

# Reading the arcslist/edgelist format
path <- system.file("extdata", "SAMPSONL.NET", package = "netdiffuseR")
SAMPSONL <- read_pajek(path)

# From DL (UCINET): Sampson monastery data (again) --------------------------
path <- system.file("extdata", "SAMPSON.DAT", package = "netdiffuseR")
SAMPSONL <- read_ml(path)

}
\seealso{
Other Foreign: \code{\link{igraph}}, \code{\link{network}},
  \code{\link{read_ucinet_head}}
}
\author{
George G. Vega Yon
}
