% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{threshold}
\alias{threshold}
\title{Retrive threshold levels from the exposure matrix}
\usage{
threshold(obj, times, t0 = min(times, na.rm = TRUE), ...)
}
\arguments{
\item{obj}{Either a \eqn{n\times T}{n * T} matrix (eposure to the innovation obtained from
\code{\link{exposure}}) or a \code{diffnet} object.}

\item{times}{Integer vector. Indicating the time of adoption of the innovation.}

\item{t0}{Integer scalar. See \code{\link{toa_mat}}.}

\item{...}{Further arguments to be passed to \code{\link{exposure}}.}
}
\value{
A vector of size \eqn{n} indicating the threshold for each node.
}
\description{
Thresholds are each vertexes exposure at the time of adoption.
Substantively it is the proportion of adopters required for each ego to adopt. (see \code{\link{exposure}}).
}
\examples{
# Generating a random graph with random Times of Adoption
set.seed(783)
toa <- sample.int(4, 5, TRUE)
graph <- rgraph_er(n=5, t=max(toa) - min(toa) + 1)

# Computing exposure using Structural Equivalnece
adopt <- toa_mat(toa)
se <- struct_equiv(graph)
se <- lapply(se, function(x) methods::as((x$SE)^(-1), "dgCMatrix"))
expo <- exposure(graph, adopt$cumadopt, alt.graph=se)

# Retrieving threshold
threshold(expo, toa)

# We can do the same by creating a diffnet object
diffnet <- as_diffnet(graph, toa)
threshold(diffnet, alt.graph=se)
}
\author{
Vega Yon, Dyal, Hayes & Valente
}
\seealso{
Threshold can be visualized using \code{\link{plot_threshold}}

Other statistics: \code{\link{cumulative_adopt_count}},
  \code{\link{dgr}}, \code{\link{exposure}},
  \code{\link{hazard_rate}}, \code{\link{infection}},
  \code{\link{moran}}, \code{\link{struct_equiv}}
}
\keyword{univar}

