% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdiffnet.R
\name{rdiffnet}
\alias{rdiffnet}
\title{Random diffnet network}
\usage{
rdiffnet(n, t, seed.nodes = "random", seed.p.adopt = 0.05,
  seed.graph = "scale-free", rgraph.args = list(), rewire = TRUE,
  rewire.args = list(p = 0.1, undirected = TRUE),
  threshold.dist = function(x) runif(1), exposure.args = list(outgoing =
  TRUE, valued = getOption("diffnet.valued", FALSE), normalized = TRUE))
}
\arguments{
\item{n}{Integer scalar. Number of vertices.}

\item{t}{Integer scalar. Time length.}

\item{seed.nodes}{Character scalar. Type of seed nodes (early adoptes).}

\item{seed.p.adopt}{Numeric scalar. Proportion of early adopters.}

\item{seed.graph}{Character scalar. Type of algorithm used to generate the
seed graph (see details).}

\item{rgraph.args}{List. Arguments to be passed to rgraph.}

\item{rewire}{Logical scalar. When TRUE, network slices are generated by rewiring
(see \code{\link{rewire_graph}}).}

\item{rewire.args}{List. Arguments to be passed to \code{\link{rewire_graph}}.}

\item{threshold.dist}{Function. Applied via \code{\link{sapply}}, sets the
adoption threshold for each node.}

\item{exposure.args}{List. Arguments to be passed to \code{link{exposure}}.}
}
\value{
A random \code{\link{diffnet}} class object.
}
\description{
Simulates a diffusion network by creating a random dynamic network and
adoption threshold levels.
}
\details{
Instead of randomizing whether an individual adopts the innovation or not, this
toy model randomizes threshold levels, seed adopters and network structure, so
an individual adopts the innovation in time \eqn{T} iff his exposure is above or
equal to his threshold. The simulation is done in the following steps:

\enumerate{
 \item Using \code{seed.graph}, a baseline graph is created.
 \item Given the baseline graph, the set of initial adopters is defined
 using \code{seed.nodes}.
 \item Afterwards, if \code{rewire=TRUE} \eqn{t-1} slices of the network are created
 by iteratively rewiring the baseline graph.
 \item The \code{threshold.dist} function is applied to each node in the graph.
 \item Simulation starts at \eqn{t=2} asigning adopters in each time period
 accordingly to each vertex's threshold and exposure.
}

\code{seed.nodes} can be \code{"marginal"}, \code{"central"} or \code{"random"},
So each of these values sets the initial adopters using the vertices with lowest
degree, with highest degree or completely randomly. The number of early adoptes
is set as \code{seed.p.adopt * n}. Please note that when marginal nodes are
set as seed it may be the case that no diffusion process is attained as the
chosen set of first adopters can be isolated.

The argument \code{seed.graph} allows the user to set the algorithm used to
generate the first network (network in t=1). This can be either "scale-free"
(Barabasi-Albert model using the \code{\link{rgraph_ba}} function, the default),
\code{"bernoulli"} (Erdos-Renyi model using the \code{\link{rgraph_er}} function),
or \code{"small-world"} (Watts-Strogatz model using the \code{\link{rgraph_ws}}
function). The list \code{rgraph.args} passes arguments to the chosen algorithm.

When \code{rewire=TRUE}, the networks that follow t=1 will be generated using the
\code{\link{rewire_graph}} function as \eqn{G(t) = G(t-1)}.

Finally, \code{threshold.dist} sets the threshold for each vertex in the graph.
It is applied using \code{sapply} as follows

\preformatted{
sapply(1:n, threshold.dist)
}

By default sets the threshold to be random for each node in the graph.
}
\examples{
# Asimple example -----------------------------------------------------------
z <- rdiffnet(50,10)
z
summary(z)

# A more complex example: Adopt if at least one neighbor has adopted --------
y <- rdiffnet(50, 10, threshold.dist=function(x) 1,
    exposure.args=list(valued=FALSE, normalized=FALSE))
}
\author{
Vega Yon
}
\seealso{
Other simulation functions: \code{\link{rewire_graph}},
  \code{\link{rgraph_ba}}, \code{\link{rgraph_er}},
  \code{\link{rgraph_ws}}
}

