% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{plot_infectsuscep}
\alias{plot_infectsuscep}
\title{Plot distribution of infect/suscep}
\usage{
plot_infectsuscep(graph, toa, t0 = NULL, normalize = TRUE, K = 1L,
  r = 0.5, expdiscount = FALSE, bins = 50, nlevels = round(bins/2),
  logscale = TRUE,
  main = "Distribution of Infectiousness and\\nSusceptibility",
  xlab = "Infectiousness of ego", ylab = "Susceptibility of ego",
  sub = ifelse(logscale, "(in log-scale)", NA), color.palette = function(n)
  grey(n:1/n), include.grid = TRUE, exclude.zeros = FALSE,
  valued = getOption("diffnet.valued", FALSE), ...)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{toa}{Integer vector of size \eqn{T}. Passed to infection/susceptibility.}

\item{t0}{Integer scalar. See \code{\link{toa_mat}}.}

\item{normalize}{Logical scalar.  Passed to infection/susceptibility.}

\item{K}{Integer scalar.  Passed to infection/susceptibility.}

\item{r}{Numeric scalar.  Passed to infection/susceptibility.}

\item{expdiscount}{Logical scalar.  Passed to infection/susceptibility.}

\item{bins}{Integer scalar. Size of the grid (\eqn{n}).}

\item{nlevels}{Integer scalar. Number of levels to plot (see \code{\link{filled.contour}}).}

\item{logscale}{Logical scalar. When TRUE the axis of the plot will be presented in log-scale.}

\item{main}{Character scalar. Title of the graph.}

\item{xlab}{Character scalar. Title of the x-axis.}

\item{ylab}{Character scalar. Title of the y-axis.}

\item{sub}{Character scalar. Subtitle of the graph.}

\item{color.palette}{a color palette function to be used to assign colors in the plot (see \code{\link{filled.contour}}).}

\item{include.grid}{Logical scalar. When TRUE, the grid of the graph is drawn.}

\item{exclude.zeros}{Logical scalar. When TRUE, observations with zero values}

\item{valued}{Logical scalar. When FALSE non-zero values in the adjmat are set to one.
in infect or suscept are excluded from the graph. This is done explicitly when \code{logscale=TRUE}.}

\item{...}{Additional parameters to be passed to \code{\link{filled.contour}.}}
}
\value{
A list with three elements:
\item{infect}{A numeric vector of size \eqn{n} with infectiousness levels}
\item{suscep}{A numeric vector of size \eqn{n} with susceptibility levels}
\item{coords}{A list containing the class marks and counts used to draw the
plot via \code{\link{filled.contour}} (see \code{\link{grid_distribution}})}
\item{complete}{A logical vector with \code{TRUE} when the case was included in
the plot. (this is relevant whenever \code{logscale=TRUE})}
}
\description{
After calculating infectiousness and susceptibility of each individual on the
network, it creates an \code{nlevels} by \code{nlevels} matrix indicating the
number of individuals that lie within each cell, and draws a heatmap.
}
\details{
This plotting function was inspired by Aral, S., & Walker, D. (2012).
}
\examples{
# Generating a random graph
set.seed(1234)
n <- 100
nper <- 20
graph <- rgraph_er(n,nper, p=.2, undirected = FALSE)
toa <- sample(1:(1+nper-1), n, TRUE)

# Visualizing distribution of suscep/infect
out <- plot_infectsuscep(graph, toa, K=3, logscale = TRUE)
}
\author{
Vega Yon
}
\references{
Aral, S., & Walker, D. (2012). "Identifying Influential and Susceptible Members
of Social Networks". Science, 337(6092), 337–341.
\url{http://doi.org/10.1126/science.1215842}
}
\seealso{
Infectiousness and susceptibility are computed via \code{\link{infection}} and
\code{\link{susceptibility}}.

Other visualizations: \code{\link{hazard_rate}},
  \code{\link{plot_adopters}}, \code{\link{plot_diffnet}},
  \code{\link{plot_threshold}}
}
\keyword{hplot}

