% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{relieff_filter}
\alias{relieff_filter}
\title{ReliefF filter}
\usage{
relieff_filter(
  y,
  x,
  nfilter = NULL,
  estimator = "ReliefFequalK",
  type = c("index", "names", "full"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix or dataframe of predictors}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors are
returned.}

\item{estimator}{Type of algorithm used, see \link[CORElearn:attrEval]{CORElearn::attrEval}}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a named vector of variable
importance.}

\item{...}{Other arguments passed to \link[CORElearn:attrEval]{CORElearn::attrEval}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} a named vector of variable importance is returned.
}
\description{
Uses ReliefF algorithm from the CORElearn package to rank predictors in order
of importance.
}
\seealso{
\code{\link[CORElearn:attrEval]{CORElearn::attrEval()}}
}
