% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{taxa,sites-method}
\alias{taxa,sites-method}
\title{Extract taxonomic data from a set of sites.}
\usage{
\S4method{taxa}{sites}(object)
}
\arguments{
\item{object}{A \code{sites} object.}
}
\value{
A \code{data.frame} reporting the taxa/data objects, units,
elements and other features within a set of records.
}
\description{
From a sites object,
}
\examples{
\donttest{
somesites <- get_sites(datasettype = "diatom", limit = 3) \%>\%
  get_downloads()
diatomtaxa <- taxa(somesites)
common_taxa <- diatomtaxa \%>\%
  dplyr::filter(sites == 3)
  }

}
