% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chroncontrol.R
\name{get_chroncontrol}
\alias{get_chroncontrol}
\title{Function to return chronological control tables used to build age models.}
\usage{
get_chroncontrol(x, chronology = 1, verbose = TRUE, add = FALSE)
}
\arguments{
\item{x}{A single numeric chronology ID, a vector of numeric dataset IDs as returned by \code{\link{get_dataset}} or a \code{download} or \code{download_list} object.}

\item{chronology}{When \code{download} objects have more than associated chronology, which chronology do you want?  Default is \code{1}.}

\item{verbose}{logical, should messages on API call be printed?}

\item{add}{logical, should this chron control be added to the download object?}
}
\value{
This command returns either an object of class  \code{"try-error"} containing the error returned
   from the Neotoma API call, or a full data object containing all the relevant information required to build either the default or prior chronology for a core.
   When \code{download} or \code{download_list} objects are passes, the user can \code{add} the chroncontrol to the
   \code{download} object explicitly, in which case the function will return a download with \code{chroncontrol} embedded.
   
   This is a list comprising the following items:

 \item{ \code{chron.control} }{A table describing the collection, including dataset information, PI data compatable with \code{\link{get_contact}} and site data compatable with \code{\link{get_site}}.}
 \item{ \code{meta} }{Dataset information for the core, primarily the age-depth model and chronology.  In cases where multiple age models exist for a single record the most recent chronology is provided here.}
 
 If Neotoma returns empty content, either the control table or the associated metadata (which happens in approximately 25% of cases) then the data.frames are returned with NA content.
}
\description{
Using the dataset ID, return all records associated with the data.  At present,
   only returns the dataset in an unparsed format, not as a data table.   This function will only download one dataset at a time.
}
\examples{
\dontrun{
#  The point of pulling chronology tables is to re-build or examine the chronological
#  information that was used to build the age-depth model for the core.  You can do this by hand,
#  but the `write_agefile` function works with `download` objects directly.

three_pines <- get_download(get_dataset(get_site("Three Pines Bog"), datasettype = "pollen"))
pines_chron <- get_chroncontrol(three_pines)

# Spline interpolation:
model <- smooth.spline(x = pines_chron[[1]]$chron.control$depth,
                       y = pines_chron[[1]]$chron.control$age)
                       
new_ages <- predict(model, x = three_pines[[1]]$sample.meta$depth)

}
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\keyword{IO}
\keyword{connection}

