% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_downloads.R
\name{compile_downloads}
\alias{compile_downloads}
\title{Function to convert multiple downloads into a single large table.}
\usage{
compile_downloads(downloads)
}
\arguments{
\item{downloads}{A download_list as returned by \code{\link{get_download}}, or mutliple downloads joined in a list.}
}
\value{
This command returns a data frame.
}
\description{
From the assemblage data for multiple cores, return a single data.frame with columns for site
metadata and assemblage data.
}
\details{
To support further synthesis and analysis \code{compile_download} works to transform a list
returned by \code{\link{get_download}} into a large data frame with columns for site and sample attributes
and also with the associated assemblage data at each sample depth.  This function also does the same for
single sites.
}
\examples{
\dontrun{
#  Search for sites with "Thuja" pollen that are older than 8kyr BP and
#  that are on the west coast of North America:
t8kyr.datasets <- get_dataset(taxonname='Thuja*', loc=c(-150, 20, -100, 60), ageyoung = 8000)

#  Returns 3 records (as of 04/04/2013), get dataset for the first record, Gold Lake Bog.
thuja.sites <- get_download(t8kyr.datasets)

gold.p25 <- compile_taxa(thuja.sites, 'P25')

all.gold <- compile_downloads(gold.p25)

pollen.sums <- rowSums(all.gold[,11:ncol(all.gold)], na.rm=TRUE)

plot(x = all.gold$age, 
     y = all.gold$Cupressaceae.Taxaceae / pollen.sums, 
     col = all.gold$site.name,
     pch = 19)

}
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org

Gavin DG, Oswald WW, Wahl ER, Williams JW. 2003. A statistical approach to evaluating distance metrics and analog assignments for pollen records. Quaternary Research 60: 356-367.

Whitmore J, Gajewski K, Sawada M, Williams JW, Shuman B, Bartlein PJ, Minckley T, Viau AE, Webb III T, Shafer S, Anderson P, Brubaker L. 2005. Modern pollen data from North America and Greenland for multi-scale paleoenvironmental applications. Quaternary Science Reviews 24: 1828-1848.

Williams J, Shuman B. 2008. Obtaining accurate and precise environmental reconstructions from the modern analog technique and North American surface pollen dataset. Quaternary Science Reviews. 27:669-687.

API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\keyword{utilities}

