% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAvg.R
\name{getAvg}
\alias{getAvg}
\title{Get a list of the available averaging intervals for a data product}
\usage{
getAvg(dpID, token = NA)
}
\arguments{
\item{dpID}{The identifier of the NEON data product, in the form DPL.PRNUM.REV, e.g. DP1.00006.001}

\item{token}{User specific API token (generated within neon.datascience user accounts)}
}
\value{
A vector of the available averaging intervals, typically in minutes.
}
\description{
Most IS products are available at multiple averaging intervals; get a list of what's available for a given data product
}
\examples{
# Get available averaging intervals for PAR data product
getAvg("DP1.00024.001")
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
