% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{vec_to_cypher}
\alias{vec_to_cypher}
\alias{vec_to_cypher_with_var}
\title{Turn a named vector into a cypher list}
\usage{
vec_to_cypher(vec, label)

vec_to_cypher_with_var(vec, label, variable)
}
\arguments{
\item{vec}{the vector}

\item{label}{the label of each vector}

\item{variable}{the variable to use (for `vec_to_cypher()`)}
}
\value{
a character vector
}
\description{
`vec_to_cypher()` creates a list, and `vec_to_cypher_with_var()`
creates a cypher call starting with a variable.
}
\details{
This function can be used with small vectors you want to send
to the server. It can for example be used this way :
```
paste("MERGE", vec_to_cypher(iris[1, 1:3], "Species"))
```
to create a cypher call.
}
\examples{

vec_to_cypher(iris[1, 1:3], "Species")
vec_to_cypher_with_var(iris[1, 1:3], "Species", a)
}
