% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightedNetworkStatistics.R
\name{WeightedNetworkStatistics}
\alias{WeightedNetworkStatistics}
\title{Weighted network statistics}
\usage{
WeightedNetworkStatistics(X, formula, theta, actor, randomSD = 0)
}
\arguments{
\item{X}{Binary network; of class \code{matrix}.}

\item{formula}{The list of local netork mechanisms to be considered.}

\item{theta}{A vector with the mechanisms' weights/strengths.}

\item{actor}{A unit (actor; row/column number), which have an opportunity to change a link.}

\item{randomSD}{The srandard deviation of a normal distribution form which the random part of weighed network statistics is sampled.}
}
\value{
The data frame with one column and the number of rows equal to the number of units.
}
\description{
It calculates the weighted network statistics, considering the selected local network mecahnisms and their weights.
}
\examples{
formula <- list(mutuality, popularity, OTPtransitivity)
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
WeightedNetworkStatistics(X = X, formula = formula, theta = c(1, 1, 1), actor = 1)
}
\author{
Marjan Cugmas and Aleš Žiberna
}
