% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{knn}
\alias{knn}
\title{Classification, regression, and clustering with k nearest neighbors.}
\usage{
knn(train_set, test_set, k = 3, categorical_target = NULL,
  continuous_target = NULL, comparison_measure,
  categorical_scoring_method = "majority_vote",
  continuous_scoring_method = "average", return_ranked_neighbors = 0,
  id = NULL)
}
\arguments{
\item{train_set}{Data frame containing the training instances, with features
and any targets and IDs.}

\item{test_set}{Data frame containing the test instances, with feature
columns only.}

\item{k}{Number of nearest neighbors.}

\item{categorical_target}{Categorical target variable.}

\item{continuous_target}{Continuous target variable.}

\item{comparison_measure}{Distance or similarity measure.}

\item{categorical_scoring_method}{Categorical scoring method.}

\item{continuous_scoring_method}{Continuous scoring method.}

\item{return_ranked_neighbors}{Number of ranked neighbors to return. A 0
indicates no ranked neighbors. Must not exceed k.}

\item{id}{Column containing unique identifiers for each row in the training
set. Only used when \code{return_ranked_neighbors} > 0.}
}
\value{
An object of class \code{neighbr}, which is a list of the following:
  \item{call}{The original call to \code{knn}.}
  \item{k}{Number of nearest neighbors.}
  \item{categorical_target}{Categorical target variable.}
  \item{continuous_target}{Continuous target variable.}
  \item{comparison_measure}{Distance or similarity measure.}
  \item{categorical_scoring_method}{Categorical scoring method.}
  \item{continuous_scoring_method}{Continuous scoring method.}
  \item{return_ranked_neighbors}{Number of ranked neighbors to return.}
  \item{id}{ID variable.}
  \item{features}{List of feature names.}
  \item{function_name}{Function name, used when generating PMML. One of
  "classification", "regression", "clustering", or "mixed".}
  \item{categorical_levels}{Levels of the categorical target.}
  \item{num_train_rows}{Number of training instances.}
  \item{num_test_rows}{Number of test instances.}
  \item{train_set}{Data frame with training instances.}
  \item{test_set_scores}{Data frame with scores for the test set.}
}
\description{
Classification, regression, and clustering with k nearest neighbors.
}
\details{
The algorithm can score data with continuous or logical features.

The algorithm can predict either a continuous or categorical target, or both
(but no more than one of each), as well as return the closest neighbors
ranked by distance or similarity. If no continuous or categorical target is
provided, return_ranked_neighbors must be non-zero, and ranked neighbors will
be returned.

There is no \code{predict} method for \code{knn}. The scored test set is returned
as part of the \code{neighbr} object. The data to be scored must be passed in
with the training data to \code{knn()}.

Supported distance measures (used with continuous features): euclidean, squared_euclidean.

Supported similarity measures (used with logical features): simple_matching, jaccard, tanimoto.

Currently, only one type of categorical_scoring_method and
continuous_scoring_method are supported (majority vote and average, respectively).

Logical features must consist of 0,1 or TRUE,FALSE values.

Categorical non-logical features must be transformed before being used.

The categorical target does not have to be of factor class, but is assumed to be not continuous.

The distance and similarity measures in this package are based on those
defined in the
\href{http://dmg.org/pmml/v4-3/ClusteringModel.html#xsdElement_ComparisonMeasure}{PMML
specification}.

Several of the elements in the returned list are only used when converting
the knn model to PMML (for example, \code{function_name}).

For more details and examples, see the vignette by running the following:

\code{vignette("neighbr-help")}
}
\examples{
# continuous features with continuous target, categorical target,
# and neighbor ranking

data(iris)

# add an ID column to the data for neighbor ranking
iris$ID <- c(1:150)

# train set contains all predicted variables, features, and ID column
train_set <- iris[1:145,]

# omit predicted variables or ID column from test set
test_set <- iris[146:150,-c(4,5,6)]

fit <- knn(train_set=train_set,test_set=test_set,
           k=5,
           categorical_target="Species",
           continuous_target= "Petal.Width",
           comparison_measure="euclidean",
           return_ranked_neighbors=3,
           id="ID")

}
\seealso{
\code{\link{similarity}}, \code{\link{distance}},
\href{http://dmg.org/pmml/v4-3/KNN.html}{PMML KNN specification}
}
