% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.reg.R, R/neg.twocors.R
\name{print.neg.reg}
\alias{print.neg.reg}
\alias{neg.twocors}
\alias{print.neg.twocors}
\title{Test for Evaluating Negligible Effects of Two Independent or Dependent Correlation Coefficients: Based on Counsell & Cribbie (2015)}
\usage{
\method{print}{neg.reg}(x, ...)

neg.twocors(
  data = NULL,
  r1v1 = NULL,
  r1v2 = NULL,
  r2v1 = NULL,
  r2v2 = NULL,
  r1 = NULL,
  n1 = NULL,
  r2 = NULL,
  n2 = NULL,
  dep = FALSE,
  r3 = NA,
  test = "AH",
  eiu,
  eil,
  alpha = 0.05,
  bootstrap = TRUE,
  nboot = 1000,
  seed = NA,
  plots = TRUE,
  saveplots = FALSE,
  ...
)

\method{print}{neg.twocors}(x, ...)
}
\arguments{
\item{x}{object of class \code{neg.twocors}}

\item{...}{additional arguments to be passed}

\item{data}{a data.frame or matrix which includes the variables in r1 and r2}

\item{r1v1}{the name of the 1st variable included in the 1st correlation coefficient (r1, variable 1)}

\item{r1v2}{the name of the 2nd variable included in the 1st correlation coefficient (r1, variable 2)}

\item{r2v1}{the name of the 1st variable included in the 2nd correlation coefficient (r2, variable 1)}

\item{r2v2}{the name of the 2nd variable included in the 2st correlation coefficient (r2, variable 2)}

\item{r1}{entered 1st correlation coefficient manually, without a dataset}

\item{n1}{entered sample size associated with r1 manually, without a dataset}

\item{r2}{entered 2nd correlation coefficient manually, without a dataset}

\item{n2}{entered sample size associated with r2 manually, without a dataset}

\item{dep}{are the correlation coefficients dependent (overlapping)?}

\item{r3}{if the correlation coefficients are dependent and no datasets were entered, specify the correlation between the two, non-intersecting variables (e.g. if r1 = r12 and r2 = r13, then r3 = r23)}

\item{test}{'AH' is the default based on recommendation in Counsell & Cribbie (2015), 'TOST' is an additional (albeit, more conservative) option.}

\item{eiu}{upper bound of the equivalence interval measured as the largest difference between the two correlations for which the two coefficients would still be considered equivalent}

\item{eil}{lower bound of the equivalence interval measured as the largest difference between the two correlations for which the two coefficients would still be considered equivalent}

\item{alpha}{desired alpha level, defualt is .05}

\item{bootstrap}{logical, default is TRUE, incorporating bootstrapping when calculating regression coefficients, SE, and CIs}

\item{nboot}{1000 is the default. indicate if other number of bootstrapping iterations is desired}

\item{seed}{to reproduce previous analyses using bootstrapping, the user can set their seed of choice}

\item{plots}{logical, plotting the results. TRUE is set as default}

\item{saveplots}{FALSE for no, "png" and "jpeg" for different formats}
}
\value{
returns a \code{list} containing each analysis and their respective statistics
  and decision
}
\description{
This function tests whether two correlation coefficients can be considered equivalent according to a predefined interval (i.e., SESOI/MMES/delta) based on the Anderson-Hauck (1983) test of equivalence
}
\examples{
# Negligible difference between two correlation coefficients
# Equivalence interval: -.15 to .15
v1a<-stats::rnorm(10)
v2a<-stats::rnorm(10)
v1b <- stats::rnorm(10)
v2b <- stats::rnorm(10)
dat<-data.frame(v1a, v2a, v1b, v2b)
# dataset available (independent correlation coefficients):
neg.twocors(r1v1=v1a,r1v2=v2a,r2v1=v1b,r2v2=v2b,data=dat,eiu=.15,eil=-0.15,nboot=50)
# end
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Alyssa Counsell \email{a.counsell@ryerson.ca}
}
