% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.esm.R
\name{neg.esm}
\alias{neg.esm}
\alias{print.neg.esm}
\title{Test for Evaluating Substantial Mediation}
\usage{
neg.esm(
  X,
  Y,
  M,
  alpha = 0.05,
  minc = 0.15,
  eil = -0.15,
  eiu = 0.15,
  nboot = 500L,
  data = NULL,
  plot = TRUE,
  saveplot = FALSE,
  seed = NA
)

\method{print}{neg.esm}(x, ...)
}
\arguments{
\item{X}{predictor variable}

\item{Y}{outcome variable}

\item{M}{mediator variable}

\item{alpha}{alpha level (default = .05)}

\item{minc}{minimum correlation between x and Y (default is .15)}

\item{eil}{lower bound of equivalence interval in standardized units(default is -.15)}

\item{eiu}{upper bound of equivalence interval in standardized units (default is .15)}

\item{nboot}{number of bootstraps (default = 500L)}

\item{data}{optional data argument}

\item{plot}{logical, plotting the results (default = TRUE)}

\item{saveplot}{saving plots (default = FALSE)}

\item{seed}{optional argument to set seed}

\item{x}{object of class \code{neg.esm}}

\item{...}{extra arguments}
}
\value{
returns a \code{list} containing each analysis and their respective statistics
  and decision
}
\description{
Function computes the equivalence testing method (total effect) for evaluating substantial mediation and Kenny method for full mediation.
}
\examples{
#equivalence test for substantial mediation
#with an equivalence interval of -.15 to .15
X<-rnorm(200,sd=2)
M<-.5*X + rnorm(100)
Y<-.5*M + rnorm(100)
neg.esm(X,Y,M, eil = -.15, eiu = .15,nboot=50)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Nataly Beribisky \email{natalyb1@yorku.ca}
}
