% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_ranges.R
\name{combine_ranges}
\alias{combine_ranges}
\title{Combines ranges from different tables into a single table.}
\usage{
combine_ranges(
  dfs,
  groups = NULL,
  start_var = NULL,
  end_var = NULL,
  startAttr = NULL,
  endAttr = NULL,
  dimension = "date",
  max_gap = 0L,
  fmt = "\%Y-\%m-\%d",
  tz = "UTC",
  origin = "1970-01-01"
)
}
\arguments{
\item{dfs}{A list of your data frames, e.g. list(df1, df2)}

\item{groups}{Grouping variables}

\item{start_var}{Start of the range}

\item{end_var}{End of the range}

\item{startAttr}{Attributes linked to start of the range which should be kept (converted to character type by default)}

\item{endAttr}{Attributes linked to end of the range which should be kept (converted to character type by default)}

\item{dimension}{Indicate whether your range includes only dates ('date') or also timestamp ('timestamp'). Defaults to 'date'}

\item{max_gap}{Gap between date or timestamp ranges, e.g. for 0, default, it will put together all records where there is no gap in-between}

\item{fmt}{The format of your date or timestamp field, defaults to YMD}

\item{tz}{Time zone, defaults to UTC}

\item{origin}{Origin for timestamp conversion, defaults to 1970-01-01}
}
\value{
Returns a data frame (if first table passed is data.table, then data.table) with combined ranges.
}
\description{
Combines ranges from different tables into a single table.
}
\examples{
df1 <- data.frame(
  start = c("2010-01-01", "2012-06-01", "2014-10-15"),
  end = c("2010-08-05", "2013-03-03", "2015-01-01"),
  group = c("a", "a", "b"),
  infoScores = c(0, 3, 2)
)

df2 <- data.frame(
  end = c("2012-04-05", "2014-06-09", "2009-02-01"),
  group = c("b", "a", "b"),
  start = c("2009-01-15", "2012-07-08", "2008-01-01"),
  score = c(8, 2, 3)
)

combine_ranges(dfs = list(df1, df2), groups = "group",
start_var = "start", end_var = "end")
}
