% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{sam.gen.fun}
\alias{sam.gen.fun}
\title{Generate a simulated dataset.}
\usage{
sam.gen.fun(n = 100, p = 50, q = 10, bmin = 0.5, bmax = 1,
  corr = 0.5, family = "gaussian", seed = NA)
}
\arguments{
\item{n}{(numeric) the number of samples.}

\item{p}{(numeric) the number of variables.}

\item{q}{(numeric) the number of nonzero coefficients.}

\item{bmin}{(numeric) value of the minimum coefficient.}

\item{bmax}{(numeric) value of the maximum coefficient.}

\item{corr}{(numeric) strength of correlations in the correlation structure.}

\item{family}{(character) model type. Default is \code{"gaussian"}.}

\item{seed}{(numeric) seed number for random generation. If set to NA, no seed will be applied. Default value is NA.}
}
\value{
An object with list class containing
  \item{x.mat}{  \code{n} times \code{p} design matrix.}
  \item{y.vec}{  vector of responses.}
  \item{b.vec}{  vector of true coefficients.}
}
\description{
Generate a synthetic dataset based on the correlation structure from generalized linear models.
}
\details{
A design matrix for regression models is generated from the multivariate normal distribution with the correlation structure.
Then the response variables are computed with a specific model based on the true coefficients. For details, see the reference.
}
\examples{
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="gaussian", seed = 1234)
head(s0$x.mat)
head(s0$y.vec)
head(s0$b.vec)

s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.2,bmax=0.5,corr=0.7,family="binomial", seed = 1234)
head(s0$y.vec)
head(s0$b.vec)

s0 = sam.gen.fun(n=100,p=20,q=5,bmin=0.5,bmax=1,corr=0.3,family="poisson", seed = 1234)
head(s0$y.vec)
head(s0$b.vec)

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
