% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{plot.ncpen}
\alias{plot.ncpen}
\title{Plots coefficients from an \code{ncpen} object.}
\usage{
\method{plot}{ncpen}(x, log.scale = FALSE, ...)
}
\arguments{
\item{x}{Fitted \code{ncpen} model object.}

\item{log.scale}{(logical) log scale of horizontal axis (a sequence of lambda values). Default value is FALSE.}

\item{...}{other graphical parameters to \code{\link{plot}}}
}
\description{
Produces a plot of the coefficients paths for a fitted \code{ncpen} object.
}
\examples{
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5, seed = 1234)
x.mat = s0$x.mat
y.vec = s0$y.vec

fit = ncpen(y.vec=y.vec, x.mat=x.mat, family="gaussian")
plot(fit,log.scale=FALSE)

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
