% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfVariable.R
\name{subset,ncdfVariable-method}
\alias{subset,ncdfVariable-method}
\title{Extract a subset of values from a variable}
\usage{
\S4method{subset}{ncdfVariable}(x, subset, rightmost.closed = FALSE, ...)
}
\arguments{
\item{x}{The \code{ncdfVariable} from which to extract a subset of values.}

\item{subset}{A list with the range to extract from each dimension of \code{x}. The
list should have elements for the dimensions to extract a subset from - if a
dimension is not present in the list the entire dimension will be extracted
from the array. List element names should be the axis designator \code{X}, \code{Y},
\code{Z} or \code{T}, or the name of the dimension - dimensions without a recognized
axis and any additional dimensions beyond the four standard ones can only
be specified by name. Axis values and dimension names are case-sensitive and
can be specified in any order. If values for the range per dimension fall
outside of the extent of the dimension, the range is clipped to the extent of
the dimension.}

\item{rightmost.closed}{Single logical value to indicate if the upper
boundary of range in each the dimension should be included.}

\item{...}{Ignored.}
}
\value{
An array with dimnames and other attributes set, or \code{NULL}.
}
\description{
This method extracts a subset of values from the array of the variable, with
the range along each dimension to extract expressed in values of the domain
of each dimension.
}
\details{
The range of values along each dimension to be subset is expressed in values
of the domain of the dimension. Any dimensions for which no information is
provided in the \code{subset} argument are extracted in whole. Values can be
specified in a variety of ways that are specific to the nature of the
dimension. For numeric dimensions it should (resolve to) be a vector of real
values. A range (e.g. \code{100:200}), a long vector (\verb{c(23, 46, 3, 45, 17}), a
sequence (\verb{seq(from = 78, to = 100, by = 2}), all work. Note, however, that
only a single range is generated from the vector so these examples resolve to
\code{100:200}, \code{3:46}, and \code{78:100}, respectively. For time dimensions a vector
of character timestamps, \code{POSIXct} or \code{Date} values must be specified. As
with numeric values, only the two extreme values in the vector will be used.

If the range of values for a dimension in \code{subset} extend the valid range
of the dimension in \code{x}, the extracted slab will start at the beginning for
smaller values and extend to the end for larger values. If the
values envelope the valid range the entire dimension will be extracted in
the result. If the range of \code{subset} values for any dimension are all either
smaller or larger than the valid range of the dimension in \code{x} then nothing
is extracted and \code{NULL} is returned.

As an example, to extract values of a variable
for Australia for the year 2020, where the first dimension in \code{x} is
the longitude, the second dimension is the latitude, both in degrees, and the
third (and final) dimension is time, the values are extracted by
\code{subset(x, list(X = c(112, 154), Y = c(-9, -44), T = c("2020-01-01", "2021-01-01")))}.
You could take the longitude-latitude values from \code{sf::st_bbox()} or
\code{terra::ext()} if you have specific spatial geometries for whom you want to
extract data. Note that this works equally well for projected coordinate
reference systems - the key is that the specification in argument \code{subset}
uses the same domain of values as the respective dimensions in \code{x} use.
}
\examples{
fn <- system.file("extdata",
  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
  package = "ncdfCF")
ds <- open_ncdf(fn)
pr <- ds[["pr"]]

# Precipitation data for March for a small area
x <- subset(pr, subset = list(X = c(9, 11),
                              Y = 42:45,
                              T = c("2024-03-01", "2024-04-01")))
dim(x)
dimnames(x)
}
