% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfDataset.R
\name{[[,ncdfDataset-method}
\alias{[[,ncdfDataset-method}
\title{Get a variable object or a dimension object from a dataset}
\usage{
\S4method{[[}{ncdfDataset}(x, i)
}
\arguments{
\item{x}{An \code{ncdfDataset} to extract a variable or a dimension from.}

\item{i}{The name of a variable or dimension in \code{x}.}
}
\value{
An instance of \code{ncdfVariable} or an \code{ncdfDimension} descendant
class, or \code{NULL} if the name is not found.
}
\description{
This method can be used to retrieve a variable or a dimension from the
dataset by name.
}
\examples{
fn <- system.file("extdata", "ERA5land_Rwanda_20160101.nc", package = "ncdfCF")
ds <- open_ncdf(fn)
v1 <- names(ds)[1]
var <- ds[[v1]]
var
}
