% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/porcelain.R
\name{read_parquet_page}
\alias{read_parquet_page}
\title{Read a page from a Parquet file}
\usage{
read_parquet_page(file, offset)
}
\arguments{
\item{file}{Path to a Parquet file.}

\item{offset}{Integer offset of the start of the page in the file.
See \code{\link[=parquet_pages]{parquet_pages()}} for a list of all pages and their offsets.}
}
\value{
Named list. Many entries correspond to the columns of
the result of \code{\link[=parquet_pages]{parquet_pages()}}. Additional entries are:
\itemize{
\item \code{codec}: compression codec. Possible values:
\item \code{has_repetition_levels}: whether the page has repetition levels.
\item \code{has_definition_levels}: whether the page has definition levels.
\item \code{schema_column}: which schema column the page corresponds to. Note
that only leaf columns have pages.
\item \code{data_type}: low level Parquet data type. Possible values:
\item \code{repetition_type}: whether the column the page belongs to is
\code{REQUIRED}, \code{OPTIONAL} or \code{REPEATED}.
\item \code{page_header}: the bytes of the page header in a raw vector.
\item \code{num_null}: number of missing (\code{NA}) values. Only set in V2 data
pages.
\item \code{num_rows}: this is the same as \code{num_values} for flat tables, i.e.
files without repetition levels.
\item \code{compressed_data}: the data of the page in a raw vector. It includes
repetition and definition levels, if any.
\item \code{data}: the uncompressed data, if nanoparquet supports the
compression codec of the file (GZIP and SNAPPY at the time of
writing), or if the file is not compressed. In the latter case it
is the same as \code{compressed_data}.
}
}
\description{
Read a page from a Parquet file
}
\examples{
\dontshow{if (Sys.getenv("IN_PKGDOWN") == "true") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
file_name <- system.file("extdata/userdata1.parquet", package = "nanoparquet")
nanoparquet:::parquet_pages(file_name)
options(max.print = 100)  # otherwise long raw vector
nanoparquet:::read_parquet_page(file_name, 4L)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=parquet_pages]{parquet_pages()}} for a summary of all pages.
}
\keyword{internal}
