% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nano.R
\name{nano}
\alias{nano}
\title{Create Nano Object}
\usage{
nano(
  protocol = c("pair", "bus", "req", "rep", "push", "pull", "pub", "sub", "surveyor",
    "respondent"),
  dial = NULL,
  listen = NULL,
  autostart = TRUE
)
}
\arguments{
\item{protocol}{[default 'pair'] choose protocol - 'pair', 'bus', 'req',
'rep', 'push', 'pull', 'pub', 'sub', 'surveyor', or 'respondent' - see
\link{protocols}.}

\item{dial}{(optional) a URL to dial, specifying the transport and address as
a character string e.g. 'inproc://anyvalue' or 'tcp://127.0.0.1:5555'
(see \link{transports}).}

\item{listen}{(optional) a URL to listen at, specifying the transport and
address as a character string e.g. 'inproc://anyvalue' or
'tcp://127.0.0.1:5555' (see \link{transports}).}

\item{autostart}{[default TRUE] whether to start the dialer/listener. Set to
FALSE if you wish to set configuration options on the dialer/listener as
it is not generally possible to change these once started.}
}
\value{
An nano object of class 'nanoObject'.
}
\description{
Create a nano object, encapsulating a Socket along with an associated
    Dialer/Listener.
}
\details{
This function encapsulates a Socket and a single Dialer and/or Listener.

    The Socket may be accessed by \code{$socket}, and the Dialer or
    Listener by \code{$dialer[[1]]} or \code{$listener[[1]]} respectively.

    The object's methods may be accessed by \code{$} e.g. \code{$send()} or
    \code{$recv()}. These methods mirror their functional equivalents, with
    the same arguments and defaults, apart from that the first argument of the
    functional equivalent is mapped to the object's encapsulated socket and
    does not need to be supplied.

    More complex network topologies may be created by binding further
    dialers or listeners using the object's \code{$dial()} and \code{$listen()}
    methods. The new dialer/listener will be attached to the object e.g. if
    the object already has a dialer, then at \code{$dialer[[2]]} etc.

    Note that \code{$dialer_setopt()} and \code{$listener_setopt()} methods
    will be available once dialers/listeners are attached to the object.
    These methods apply settings to all dialers or listeners equally. To
    apply settings to individual dialers/listeners, access them directly
    via \code{$dialer[[2]]} or \code{$listener[[2]]} etc.
}
\examples{
nano <- nano("bus", listen = "inproc://nanonext")
nano
nano$socket
nano$listener[[1]]

nano$socket_setopt("ms", "send-timeout", 1000)

nano$listen(url = "inproc://nanonextgen")
nano$listener

nano1 <- nano("bus", dial = "inproc://nanonext")
nano$send("example test", mode = "raw")
nano1$recv("character")

nano$close()
nano1$close()

}
