% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv_vec_aio}
\alias{recv_vec_aio}
\title{Receive Vector Async}
\usage{
recv_vec_aio(
  socket,
  mode = c("character", "complex", "double", "integer", "logical", "numeric", "raw"),
  n = 1L,
  timeout,
  keep.raw = TRUE
)
}
\arguments{
\item{socket}{a Socket.}

\item{mode}{[default 'character'] mode of vector to be read - one of
'character', 'complex', 'double', 'integer', 'logical', 'numeric', 'raw'.}

\item{n}{[default 1L] number of messages to receive asynchronously.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}

\item{keep.raw}{[default TRUE] TRUE to keep the received raw vector (useful
for verification e.g. via hashing, or in case of an error in decoding to
'mode'). If FALSE, will return the decoded object only.}
}
\value{
Named list of 2 elements: 'raw' containing a list of received raw
    vectors and 'data' containing a list of vectors decoded to the type 'mode',
    or else a list of vectors decoded to type 'mode' if keep.raw is set to
    FALSE.

    Note: a list of lists is always returned even when n = 1. To access the
    first raw element, for example, use \code{$raw[[1]]} and the first data
    element use \code{$data[[1]]}.
}
\description{
Receive vector data asynchronously over a Socket (with ability to set a
    timeout). The counterpart to \code{\link{send_vec_aio}}, data will be
    re-created from the raw vector according to the specified mode. Can be
    used when interfacing with external programs.
}
\details{
Async recv will block while awaiting all 'n' messages to arrive. Set
    a timeout to ensure that the function returns under all conditions.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

send_vec_aio(s1, c(1.1, 2.2), c(3.3, 4.4), timeout = 100)
res <- recv_vec_aio(s2, "double", 2L, timeout = 100)
res

send_vec_aio(s1, "message 1", "message 2", timeout = 100)
recv_vec_aio(s2, "character", 2L, timeout = 100, keep.raw = FALSE)

close(s1)
close(s2)

}
